/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug;

import io.gravitee.common.event.EventManager;
import io.gravitee.gateway.core.classloader.DefaultClassLoader;
import io.gravitee.gateway.core.component.ComponentProvider;
import io.gravitee.gateway.core.condition.ConditionEvaluator;
import io.gravitee.gateway.core.condition.ExpressionLanguageStringConditionEvaluator;
import io.gravitee.gateway.debug.handlers.api.DebugApiContextHandlerFactory;
import io.gravitee.gateway.debug.platform.manager.DebugOrganizationManager;
import io.gravitee.gateway.debug.policy.impl.PolicyDebugDecoratorFactoryCreator;
import io.gravitee.gateway.debug.vertx.VertxDebugService;
import io.gravitee.gateway.flow.FlowPolicyResolverFactory;
import io.gravitee.gateway.flow.FlowResolver;
import io.gravitee.gateway.flow.policy.PolicyChainFactory;
import io.gravitee.gateway.handlers.api.definition.Api;
import io.gravitee.gateway.platform.OrganizationFlowResolver;
import io.gravitee.gateway.platform.PlatformPolicyManager;
import io.gravitee.gateway.platform.manager.OrganizationManager;
import io.gravitee.gateway.platform.providers.OnRequestPlatformPolicyChainProvider;
import io.gravitee.gateway.platform.providers.OnResponsePlatformPolicyChainProvider;
import io.gravitee.gateway.policy.ConfigurablePolicyChainProvider;
import io.gravitee.gateway.policy.PolicyChainProviderLoader;
import io.gravitee.gateway.policy.PolicyConfigurationFactory;
import io.gravitee.gateway.policy.PolicyFactoryCreator;
import io.gravitee.gateway.policy.PolicyManager;
import io.gravitee.gateway.policy.PolicyPluginFactory;
import io.gravitee.gateway.policy.impl.PolicyFactoryCreatorImpl;
import io.gravitee.gateway.reactor.handler.EntrypointResolver;
import io.gravitee.gateway.reactor.handler.ReactorHandlerFactory;
import io.gravitee.gateway.reactor.handler.ReactorHandlerFactoryManager;
import io.gravitee.gateway.reactor.handler.ReactorHandlerRegistry;
import io.gravitee.gateway.reactor.handler.impl.DefaultEntrypointResolver;
import io.gravitee.gateway.reactor.handler.impl.DefaultReactorHandlerRegistry;
import io.gravitee.gateway.resource.ResourceLifecycleManager;
import io.gravitee.node.api.Node;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.policy.PolicyClassLoaderFactory;
import io.gravitee.plugin.policy.PolicyPlugin;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;

@Configuration
public class DebugConfiguration {
    private final ApplicationContext applicationContext;
    private final Node node;
    private final io.gravitee.node.api.configuration.Configuration configuration;

    public DebugConfiguration(ApplicationContext applicationContext, Node node, io.gravitee.node.api.configuration.Configuration configuration) {
        this.applicationContext = applicationContext;
        this.node = node;
        this.configuration = configuration;
    }

    @Bean
    public VertxDebugService vertxDebugService() {
        return new VertxDebugService();
    }

    @Bean
    @Qualifier(value="debugPolicyFactoryCreator")
    public PolicyFactoryCreator debugPolicyFactoryCreator(PolicyPluginFactory policyPluginFactory) {
        return new PolicyDebugDecoratorFactoryCreator((PolicyFactoryCreator)new PolicyFactoryCreatorImpl(this.configuration, policyPluginFactory, (ConditionEvaluator)new ExpressionLanguageStringConditionEvaluator()));
    }

    @Bean
    @Qualifier(value="debugReactorHandlerFactory")
    public ReactorHandlerFactory<Api> reactorHandlerFactory(@Qualifier(value="debugPolicyFactoryCreator") PolicyFactoryCreator policyFactoryCreator, @Qualifier(value="debugPolicyChainProviderLoader") PolicyChainProviderLoader policyChainProviderLoader) {
        return new DebugApiContextHandlerFactory(this.applicationContext.getParent(), this.configuration, this.node, policyFactoryCreator, policyChainProviderLoader);
    }

    @Bean
    @Qualifier(value="debugReactorHandlerFactoryManager")
    public ReactorHandlerFactoryManager reactorHandlerFactoryManager(@Qualifier(value="debugReactorHandlerFactory") ReactorHandlerFactory reactorHandlerFactory) {
        return new ReactorHandlerFactoryManager(reactorHandlerFactory);
    }

    @Bean
    @Qualifier(value="debugReactorHandlerRegistry")
    public ReactorHandlerRegistry reactorHandlerRegistry(ReactorHandlerFactoryManager reactorHandlerFactoryManager) {
        return new DefaultReactorHandlerRegistry(reactorHandlerFactoryManager);
    }

    @Bean
    @Qualifier(value="debugEntryPointResolver")
    public EntrypointResolver reactorHandlerResolver(@Qualifier(value="debugReactorHandlerRegistry") ReactorHandlerRegistry reactorHandlerRegistry) {
        return new DefaultEntrypointResolver(reactorHandlerRegistry);
    }

    @Bean
    @Qualifier(value="debugPolicyChainProviderLoader")
    public PolicyChainProviderLoader policyChainProviderLoader(@Qualifier(value="debugConfigurablePolicyChainProvider") List<ConfigurablePolicyChainProvider> providers) {
        return new PolicyChainProviderLoader(providers);
    }

    @Bean
    @Qualifier(value="debugConfigurablePolicyChainProvider")
    public OnRequestPlatformPolicyChainProvider onRequestPlatformPolicyChainProvider(@Qualifier(value="debugFlowResolver") FlowResolver flowResolver, @Qualifier(value="debugPlatformPolicyChainFactory") PolicyChainFactory policyChainFactory) {
        return new OnRequestPlatformPolicyChainProvider(flowResolver, policyChainFactory, new FlowPolicyResolverFactory());
    }

    @Bean
    @Qualifier(value="debugConfigurablePolicyChainProvider")
    public OnResponsePlatformPolicyChainProvider onResponsePlatformPolicyChainProvider(@Qualifier(value="debugFlowResolver") FlowResolver flowResolver, @Qualifier(value="debugPlatformPolicyChainFactory") PolicyChainFactory policyChainFactory) {
        return new OnResponsePlatformPolicyChainProvider(flowResolver, policyChainFactory, new FlowPolicyResolverFactory());
    }

    @Bean
    @Qualifier(value="debugFlowResolver")
    public FlowResolver flowResolver(@Qualifier(value="debugOrganizationManager") OrganizationManager organizationManager) {
        return new OrganizationFlowResolver(organizationManager);
    }

    @Bean
    @Qualifier(value="debugPlatformPolicyChainFactory")
    public PolicyChainFactory policyChainFactory(@Qualifier(value="debugPlatformPolicyManager") PlatformPolicyManager platformPolicyManager) {
        return new PolicyChainFactory((PolicyManager)platformPolicyManager);
    }

    @Bean
    @Qualifier(value="debugOrganizationManager")
    public OrganizationManager organizationManager(@Qualifier(value="debugPlatformPolicyManager") PlatformPolicyManager policyManager, EventManager eventManager) {
        return new DebugOrganizationManager(policyManager, eventManager);
    }

    @Bean
    @Qualifier(value="debugPlatformPolicyManager")
    public PlatformPolicyManager platformPolicyManager(@Qualifier(value="debugPolicyFactoryCreator") PolicyFactoryCreator factory, PolicyConfigurationFactory policyConfigurationFactory, PolicyClassLoaderFactory policyClassLoaderFactory, ResourceLifecycleManager resourceLifecycleManager, ComponentProvider componentProvider) {
        ApplicationContext contextParent = this.applicationContext.getParent();
        String[] beanNamesForType = contextParent.getBeanNamesForType(ResolvableType.forClassWithGenerics(ConfigurablePluginManager.class, (Class[])new Class[]{PolicyPlugin.class}));
        ConfigurablePluginManager cpm = (ConfigurablePluginManager)contextParent.getBean(beanNamesForType[0]);
        return new PlatformPolicyManager(((Boolean)this.configuration.getProperty("classloader.legacy.enabled", Boolean.class, (Object)false)).booleanValue(), (DefaultClassLoader)contextParent.getBean(DefaultClassLoader.class), factory.create(), policyConfigurationFactory, cpm, policyClassLoaderFactory, resourceLifecycleManager, componentProvider);
    }
}

