/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.event.EventListener;
import io.gravitee.definition.model.HttpRequest;
import io.gravitee.definition.model.HttpResponse;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.gateway.debug.definition.DebugApi;
import io.gravitee.gateway.debug.vertx.VertxDebugHttpClientConfiguration;
import io.gravitee.gateway.reactor.Reactable;
import io.gravitee.gateway.reactor.ReactorEvent;
import io.gravitee.gateway.reactor.handler.ReactorHandlerRegistry;
import io.gravitee.gateway.reactor.impl.DefaultReactor;
import io.gravitee.gateway.reactor.impl.ReactableWrapper;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.model.ApiDebugStatus;
import io.gravitee.repository.management.model.Event;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DebugReactor
extends DefaultReactor {
    private final Logger logger = LoggerFactory.getLogger(DebugReactor.class);
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private Vertx vertx;
    @Autowired
    private VertxDebugHttpClientConfiguration debugHttpClientConfiguration;
    @Autowired
    @Qualifier(value="debugReactorHandlerRegistry")
    private ReactorHandlerRegistry reactorHandlerRegistry;

    public void onEvent(io.gravitee.common.event.Event<ReactorEvent, Reactable> reactorEvent) {
        if (reactorEvent.type() == ReactorEvent.DEBUG) {
            this.logger.debug("Try to deploy api for debug...");
            ReactableWrapper reactableWrapper = (ReactableWrapper)reactorEvent.content();
            Event debugEvent = (Event)reactableWrapper.getContent();
            DebugApi reactableDebugApi = this.toReactableDebugApi((Event)reactableWrapper.getContent());
            if (reactableDebugApi != null) {
                if (this.reactorHandlerRegistry.contains((Reactable)reactableDebugApi)) {
                    this.logger.debug("Reactable already deployed. No need to do it again.");
                    return;
                }
                this.logger.info("Deploy api for debug...");
                this.logger.debug("Creating ReactorHandler");
                this.reactorHandlerRegistry.create((Reactable)reactableDebugApi);
                try {
                    HttpRequest req = reactableDebugApi.getRequest();
                    HttpResponse response = new HttpResponse();
                    this.updateEvent(debugEvent, ApiDebugStatus.DEBUGGING);
                    this.logger.info("Sending request to debug...");
                    HttpClient httpClient = this.vertx.createHttpClient(this.buildClientOptions());
                    Future<HttpClientRequest> requestFuture = this.prepareRequest(reactableDebugApi, req, httpClient);
                    requestFuture.flatMap(reqEvent -> req.getBody() == null ? reqEvent.send() : reqEvent.send(req.getBody())).flatMap(result -> {
                        this.logger.debug("Response status: {}", (Object)result.statusCode());
                        return result.body();
                    }).onSuccess(bodyEvent -> {
                        this.logger.debug("Response body: {}", bodyEvent);
                        this.logger.info("Debugging successful, removing the handler.");
                        this.reactorHandlerRegistry.remove((Reactable)reactableDebugApi);
                        this.logger.info("The debug handler has been removed");
                    }).onFailure(throwable -> {
                        this.logger.error("Debugging API has failed, removing the handler.", throwable);
                        this.reactorHandlerRegistry.remove((Reactable)reactableDebugApi);
                        this.failEvent(debugEvent);
                    });
                }
                catch (TechnicalException e) {
                    this.logger.error("An error occurred when debugging api for event {}, removing the handler.", (Object)reactableDebugApi.getEventId(), (Object)e);
                    this.reactorHandlerRegistry.remove((Reactable)reactableDebugApi);
                    this.failEvent(debugEvent);
                }
            }
        }
    }

    private DebugApi toReactableDebugApi(Event event) {
        try {
            io.gravitee.definition.model.debug.DebugApi eventPayload = (io.gravitee.definition.model.debug.DebugApi)this.objectMapper.readValue(event.getPayload(), io.gravitee.definition.model.debug.DebugApi.class);
            DebugApi debugApi = new DebugApi(event.getId(), eventPayload);
            debugApi.setEnabled(true);
            debugApi.setDeployedAt(new Date());
            return debugApi;
        }
        catch (Exception e) {
            this.logger.error("Unable to extract api definition from event [{}].", (Object)event.getId());
            this.failEvent(event);
            return null;
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.eventManager.subscribeForEvents((EventListener)this, ReactorEvent.class);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.reactorHandlerRegistry.clear();
    }

    private HttpClientOptions buildClientOptions() {
        HttpClientOptions options = new HttpClientOptions();
        options.setDefaultHost(this.debugHttpClientConfiguration.getHost());
        options.setDefaultPort(this.debugHttpClientConfiguration.getPort());
        options.setConnectTimeout(this.debugHttpClientConfiguration.getConnectTimeout());
        options.setTryUseCompression(this.debugHttpClientConfiguration.isCompressionSupported());
        options.setUseAlpn(this.debugHttpClientConfiguration.isAlpn());
        if (this.debugHttpClientConfiguration.isSecured()) {
            options.setSsl(this.debugHttpClientConfiguration.isSecured());
            options.setTrustAll(true);
            if (this.debugHttpClientConfiguration.isOpenssl()) {
                options.setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions());
            }
        }
        return options;
    }

    private Future<HttpClientRequest> prepareRequest(DebugApi debugApi, HttpRequest req, HttpClient httpClient) {
        Future future = httpClient.request(new RequestOptions().setMethod(HttpMethod.valueOf((String)req.getMethod())).setHeaders(this.buildHeaders(debugApi, req)).setURI(((VirtualHost)debugApi.getProxy().getVirtualHosts().get(0)).getPath() + req.getPath()).setTimeout((long)this.debugHttpClientConfiguration.getRequestTimeout())).map(httpClientRequest -> httpClientRequest.setChunked(true));
        return future;
    }

    private MultiMap buildHeaders(DebugApi debugApi, HttpRequest req) {
        String host;
        HeadersMultiMap headers = new HeadersMultiMap();
        if (debugApi.getProxy().getVirtualHosts().size() > 1 && (host = ((VirtualHost)debugApi.getProxy().getVirtualHosts().get(0)).getHost()) != null) {
            headers.add("Host", host);
        }
        return headers.addAll(this.convertHeaders(req.getHeaders()));
    }

    private void failEvent(Event debugEvent) {
        try {
            if (debugEvent != null) {
                this.updateEvent(debugEvent, ApiDebugStatus.ERROR);
            }
        }
        catch (TechnicalException e) {
            this.logger.error("Error when updating event {} with ERROR status", (Object)debugEvent.getId());
        }
    }

    private void updateEvent(Event debugEvent, ApiDebugStatus apiDebugStatus) throws TechnicalException {
        debugEvent.getProperties().put(Event.EventProperties.API_DEBUG_STATUS.getValue(), apiDebugStatus.name());
        this.eventRepository.update((Object)debugEvent);
    }

    MultiMap convertHeaders(Map<String, List<String>> headers) {
        HeadersMultiMap headersMultiMap = new HeadersMultiMap();
        if (headers != null) {
            headers.forEach((key, value) -> headersMultiMap.add(key, String.join((CharSequence)", ", value)));
        }
        return headersMultiMap;
    }
}

