/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.reactor.handler.context.steps;

import io.gravitee.definition.model.PolicyScope;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.debug.reactor.handler.context.steps.DebugStep;
import io.gravitee.gateway.policy.StreamType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DebugResponseStep
extends DebugStep<Response> {
    public DebugResponseStep(String policyId, StreamType streamType, String uuid, PolicyScope policyScope) {
        super(policyId, streamType, uuid, policyScope);
    }

    @Override
    public void snapshotInputData(Response response, Map<String, Serializable> attributes) {
        this.policyInputContent.headers(response.headers()).statusCode(response.status()).reason(response.reason()).attributes(attributes);
    }

    @Override
    public void generateDiffMap(Response response, Map<String, Serializable> attributes, Buffer inputBuffer, Buffer outputBuffer) {
        Buffer output;
        if (!this.policyInputContent.getHeaders().deeplyEquals(response.headers())) {
            this.diffMap.put("headers", HttpHeaders.create((HttpHeaders)response.headers()));
        }
        if (this.policyInputContent.getStatusCode().intValue() != response.status()) {
            this.diffMap.put("statusCode", response.status());
        }
        if (this.policyInputContent.getReason() != null && !this.policyInputContent.getReason().equals(response.reason())) {
            this.diffMap.put("reason", response.reason());
        }
        if (!this.policyInputContent.getAttributes().equals(attributes)) {
            this.diffMap.put("attributes", new HashMap<String, Serializable>(attributes));
        }
        Buffer input = inputBuffer != null ? inputBuffer : Buffer.buffer();
        Buffer buffer = output = outputBuffer != null ? outputBuffer : Buffer.buffer();
        if (!input.getNativeBuffer().equals(output.getNativeBuffer())) {
            this.diffMap.put("bodyBuffer", Buffer.buffer((byte[])output.getBytes()));
        }
    }
}

