/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.reactor.handler.context.steps;

import io.gravitee.common.util.LinkedMultiValueMap;
import io.gravitee.common.util.MultiValueMap;
import io.gravitee.definition.model.PolicyScope;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.debug.reactor.handler.context.steps.DebugStep;
import io.gravitee.gateway.policy.StreamType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DebugRequestStep
extends DebugStep<Request> {
    public DebugRequestStep(String policyId, StreamType streamType, String uuid, PolicyScope policyScope) {
        super(policyId, streamType, uuid, policyScope);
    }

    @Override
    public void snapshotInputData(Request request, Map<String, Serializable> attributes) {
        this.policyInputContent.contextPath(request.contextPath()).parameters((MultiValueMap<String, String>)request.parameters()).method(request.method()).path(request.path()).pathParameters((MultiValueMap<String, String>)request.pathParameters()).headers(request.headers()).attributes(attributes);
    }

    @Override
    public void generateDiffMap(Request request, Map<String, Serializable> attributes, Buffer inputBuffer, Buffer outputBuffer) {
        Buffer output;
        if (!this.policyInputContent.getHeaders().deeplyEquals(request.headers())) {
            this.diffMap.put("headers", HttpHeaders.create((HttpHeaders)request.headers()));
        }
        if (!this.policyInputContent.getParameters().equals((Object)request.parameters())) {
            this.diffMap.put("parameters", new LinkedMultiValueMap((Map)request.parameters()));
        }
        if (!this.policyInputContent.getPathParameters().equals((Object)request.pathParameters())) {
            this.diffMap.put("pathParameters", new LinkedMultiValueMap((Map)request.pathParameters()));
        }
        if (!this.policyInputContent.getMethod().equals((Object)request.method())) {
            this.diffMap.put("method", request.method());
        }
        if (!this.policyInputContent.getPath().equals(request.path())) {
            this.diffMap.put("path", request.path());
        }
        if (!this.policyInputContent.getContextPath().equals(request.contextPath())) {
            this.diffMap.put("contextPath", request.contextPath());
        }
        if (!this.policyInputContent.getAttributes().equals(attributes)) {
            this.diffMap.put("attributes", new HashMap<String, Serializable>(attributes));
        }
        Buffer input = inputBuffer != null ? inputBuffer : Buffer.buffer();
        Buffer buffer = output = outputBuffer != null ? outputBuffer : Buffer.buffer();
        if (!input.getNativeBuffer().equals(output.getNativeBuffer())) {
            this.diffMap.put("bodyBuffer", Buffer.buffer((byte[])output.getBytes()));
        }
    }
}

