/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.reactor.handler.context;

import io.gravitee.el.TemplateEngine;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.context.MutableExecutionContext;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.debug.core.invoker.InvokerResponse;
import io.gravitee.gateway.debug.reactor.handler.context.AttributeHelper;
import io.gravitee.gateway.debug.reactor.handler.context.steps.DebugRequestStep;
import io.gravitee.gateway.debug.reactor.handler.context.steps.DebugResponseStep;
import io.gravitee.gateway.debug.reactor.handler.context.steps.DebugStep;
import io.gravitee.gateway.policy.StreamType;
import io.gravitee.tracing.api.Tracer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public class DebugExecutionContext
implements MutableExecutionContext {
    private final MutableExecutionContext context;
    private final List<DebugStep<?>> steps = new ArrayList();
    private final Map<String, Serializable> initialAttributes;
    private final InvokerResponse invokerResponse = new InvokerResponse();
    private final HttpHeaders initialHeaders;

    public DebugExecutionContext(ExecutionContext context) {
        this.context = (MutableExecutionContext)context;
        this.initialAttributes = AttributeHelper.filterAndSerializeAttributes(context.getAttributes());
        this.initialHeaders = HttpHeaders.create((HttpHeaders)this.request().headers());
    }

    public Map<String, Serializable> getInitialAttributes() {
        return this.initialAttributes;
    }

    public void beforePolicyExecution(DebugStep<?> debugStep) {
        if (!this.steps.contains(debugStep)) {
            this.steps.add(debugStep);
            if (StreamType.ON_REQUEST.equals((Object)debugStep.getStreamType())) {
                ((DebugRequestStep)debugStep).before(this.request(), this.context.getAttributes());
            } else {
                ((DebugResponseStep)debugStep).before(this.response(), this.context.getAttributes());
            }
        }
    }

    public void afterPolicyExecution(DebugStep<?> debugStep) {
        this.afterPolicyExecution(debugStep, null, null);
    }

    public void afterPolicyExecution(DebugStep<?> debugStep, Buffer initialBuffer, Buffer finalBuffer) {
        if (!debugStep.isEnded()) {
            if (StreamType.ON_REQUEST.equals((Object)debugStep.getStreamType())) {
                ((DebugRequestStep)debugStep).after(this.request(), this.context.getAttributes(), initialBuffer, finalBuffer);
            } else {
                ((DebugResponseStep)debugStep).after(this.response(), this.context.getAttributes(), initialBuffer, finalBuffer);
            }
            debugStep.ended();
        }
    }

    public Request request() {
        return this.context.request();
    }

    public Response response() {
        return this.context.response();
    }

    public <T> T getComponent(Class<T> componentClass) {
        return (T)this.context.getComponent(componentClass);
    }

    public void setAttribute(String name, Object value) {
        this.context.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.context.removeAttribute(name);
    }

    public Object getAttribute(String name) {
        return this.context.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.context.getAttributeNames();
    }

    public Map<String, Object> getAttributes() {
        return this.context.getAttributes();
    }

    public TemplateEngine getTemplateEngine() {
        return this.context.getTemplateEngine();
    }

    public Tracer getTracer() {
        return this.context.getTracer();
    }

    public List<DebugStep<?>> getDebugSteps() {
        return this.steps;
    }

    public InvokerResponse getInvokerResponse() {
        return this.invokerResponse;
    }

    public HttpHeaders getInitialHeaders() {
        return this.initialHeaders;
    }

    public MutableExecutionContext request(Request request) {
        this.context.request(request);
        return this;
    }

    public MutableExecutionContext response(Response response) {
        this.context.response(response);
        return this;
    }
}

