/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.policy.impl;

import io.gravitee.common.utils.UUID;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.stream.ReadWriteStream;
import io.gravitee.gateway.debug.policy.impl.DebugConditionalExecutablePolicy;
import io.gravitee.gateway.debug.policy.impl.DebugPolicyChain;
import io.gravitee.gateway.debug.policy.impl.DebugReadWriteStream;
import io.gravitee.gateway.debug.policy.impl.DebugStreamablePolicyChain;
import io.gravitee.gateway.debug.reactor.handler.context.DebugExecutionContext;
import io.gravitee.gateway.debug.reactor.handler.context.steps.DebugStep;
import io.gravitee.gateway.debug.reactor.handler.context.steps.DebugStepFactory;
import io.gravitee.gateway.policy.Policy;
import io.gravitee.gateway.policy.PolicyException;
import io.gravitee.gateway.policy.StreamType;
import io.gravitee.gateway.policy.impl.ConditionalExecutablePolicy;
import io.gravitee.policy.api.PolicyChain;

public class PolicyDebugDecorator
implements Policy {
    private final StreamType streamType;
    private final Policy policy;
    private final String uuid;

    public PolicyDebugDecorator(StreamType streamType, Policy policy) {
        this.streamType = streamType;
        this.policy = policy;
        this.uuid = new UUID().randomString();
    }

    public String id() {
        return this.policy.id();
    }

    public void execute(PolicyChain chain, ExecutionContext context) throws PolicyException {
        DebugExecutionContext debugContext = (DebugExecutionContext)context;
        DebugStep<?> debugStep = DebugStepFactory.createExecuteDebugStep(this.policy.id(), this.streamType, this.uuid);
        DebugPolicyChain debugPolicyChain = new DebugPolicyChain(chain, debugStep, debugContext);
        Policy policy = this.computeConditionalPolicy(debugStep);
        debugContext.beforePolicyExecution(debugStep);
        try {
            policy.execute((PolicyChain)debugPolicyChain, context);
        }
        catch (Throwable ex) {
            debugStep.error(ex);
            throw ex;
        }
    }

    public ReadWriteStream<Buffer> stream(PolicyChain chain, ExecutionContext context) throws PolicyException {
        DebugExecutionContext debugContext = (DebugExecutionContext)context;
        DebugStep<?> debugStep = DebugStepFactory.createStreamDebugStep(this.policy.id(), this.streamType, this.uuid);
        Policy policy = this.computeConditionalPolicy(debugStep);
        DebugStreamablePolicyChain debugPolicyChain = new DebugStreamablePolicyChain(chain, debugStep, debugContext);
        try {
            ReadWriteStream stream = policy.stream((PolicyChain)debugPolicyChain, context);
            if (stream == null) {
                return null;
            }
            return new DebugReadWriteStream(debugContext, (ReadWriteStream<Buffer>)stream, debugStep);
        }
        catch (Throwable ex) {
            debugStep.error(ex);
            throw ex;
        }
    }

    public boolean isStreamable() {
        return this.policy.isStreamable();
    }

    public boolean isRunnable() {
        return this.policy.isRunnable();
    }

    private Policy computeConditionalPolicy(DebugStep<?> debugStep) {
        return this.policy instanceof ConditionalExecutablePolicy ? new DebugConditionalExecutablePolicy((ConditionalExecutablePolicy)this.policy, debugStep) : this.policy;
    }
}

