/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.vertx;

import io.gravitee.gateway.debug.reactor.DebugReactor;
import io.gravitee.gateway.debug.vertx.DebugReactorVerticle;
import io.gravitee.gateway.debug.vertx.VertxDebugHttpClientConfiguration;
import io.gravitee.gateway.reactor.Reactor;
import io.gravitee.gateway.reactor.processor.NotFoundProcessorChainFactory;
import io.gravitee.gateway.reactor.processor.RequestProcessorChainFactory;
import io.gravitee.gateway.reactor.processor.ResponseProcessorChainFactory;
import io.gravitee.gateway.reactor.processor.transaction.TraceContextProcessorFactory;
import io.gravitee.gateway.reactor.processor.transaction.TransactionProcessorFactory;
import io.gravitee.node.certificates.KeyStoreLoaderManager;
import io.gravitee.node.vertx.VertxHttpServerFactory;
import io.gravitee.node.vertx.configuration.HttpServerConfiguration;
import io.vertx.core.Vertx;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;

@Configuration
public class VertxDebugConfiguration {
    @Bean
    @Scope(value="prototype")
    public DebugReactorVerticle graviteeDebugVerticle() {
        return new DebugReactorVerticle();
    }

    @Bean
    public Reactor reactor() {
        return new DebugReactor();
    }

    @Bean
    public TransactionProcessorFactory transactionHandlerFactory() {
        return new TransactionProcessorFactory();
    }

    @Bean
    public TraceContextProcessorFactory traceContextHandlerFactory() {
        return new TraceContextProcessorFactory();
    }

    @Bean
    public RequestProcessorChainFactory requestProcessorChainFactory() {
        return new RequestProcessorChainFactory();
    }

    @Bean
    public ResponseProcessorChainFactory responseProcessorChainFactory() {
        return new ResponseProcessorChainFactory();
    }

    @Bean
    public NotFoundProcessorChainFactory notFoundProcessorChainFactory() {
        return new NotFoundProcessorChainFactory();
    }

    @Bean(value={"debugHttpServerConfiguration"})
    public HttpServerConfiguration debugHttpServerConfiguration(Environment environment) {
        return HttpServerConfiguration.builder().withEnvironment(environment).withPort(Integer.parseInt(environment.getProperty("debug.http.port", "8482"))).withHost(environment.getProperty("debug.http.host", "localhost")).build();
    }

    @Bean(value={"gatewayDebugHttpServer"})
    @Scope(value="prototype")
    public VertxHttpServerFactory vertxHttpServerFactory(Vertx vertx, @Qualifier(value="debugHttpServerConfiguration") HttpServerConfiguration httpServerConfiguration, KeyStoreLoaderManager keyStoreLoaderManager) {
        return new VertxHttpServerFactory(vertx, httpServerConfiguration, keyStoreLoaderManager);
    }

    @Bean(value={"debugHttpClientConfiguration"})
    public VertxDebugHttpClientConfiguration debugHttpClientConfiguration() {
        return new VertxDebugHttpClientConfiguration();
    }
}

