/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.vertx;

import io.gravitee.common.event.EventManager;
import io.gravitee.common.http.IdGenerator;
import io.gravitee.common.utils.Hex;
import io.gravitee.common.utils.UUID;
import io.gravitee.gateway.debug.vertx.VertxDebugHttpConfiguration;
import io.gravitee.gateway.debug.vertx.VertxDebugReactorHandler;
import io.gravitee.gateway.reactor.Reactor;
import io.gravitee.gateway.reactor.handler.ReactorHandlerRegistry;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class DebugReactorVerticle
extends AbstractVerticle {
    private static final String HEX_FORMAT = "hex";
    private final Logger logger = LoggerFactory.getLogger(DebugReactorVerticle.class);
    @Autowired
    @Qualifier(value="gatewayDebugHttpServer")
    private HttpServer httpServer;
    @Autowired
    private Reactor reactor;
    @Autowired
    private VertxDebugHttpConfiguration debugHttpConfiguration;
    @Value(value="${handlers.request.format:uuid}")
    private String requestFormat;
    @Autowired
    @Qualifier(value="debugReactorHandlerRegistry")
    protected ReactorHandlerRegistry reactorHandlerRegistry;
    @Autowired
    protected EventManager eventManager;

    public void start(Promise<Void> startPromise) throws Exception {
        Object idGenerator = HEX_FORMAT.equals(this.requestFormat) ? new Hex() : new UUID();
        VertxDebugReactorHandler handler = new VertxDebugReactorHandler(this.reactor, (IdGenerator)idGenerator);
        this.httpServer.requestHandler((Handler)handler);
        this.httpServer.listen(res -> {
            if (res.succeeded()) {
                this.logger.info("Debug HTTP listener ready to accept requests on port {}", (Object)this.debugHttpConfiguration.getPort());
                startPromise.complete();
            } else {
                this.logger.error("Unable to start Debug HTTP Server", res.cause());
                startPromise.fail(res.cause());
            }
        });
    }

    public void stop() throws Exception {
        this.logger.info("Stopping Debug HTTP Server...");
        this.httpServer.close(voidAsyncResult -> this.logger.info("Debug HTTP Server has been correctly stopped"));
    }
}

