/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.reactor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.event.EventListener;
import io.gravitee.definition.model.HttpRequest;
import io.gravitee.definition.model.HttpResponse;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.gateway.debug.definition.DebugApi;
import io.gravitee.gateway.debug.vertx.VertxDebugHttpConfiguration;
import io.gravitee.gateway.reactor.Reactable;
import io.gravitee.gateway.reactor.ReactorEvent;
import io.gravitee.gateway.reactor.handler.ReactorHandlerRegistry;
import io.gravitee.gateway.reactor.impl.DefaultReactor;
import io.gravitee.gateway.reactor.impl.ReactableWrapper;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.model.ApiDebugStatus;
import io.gravitee.repository.management.model.Event;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DebugReactor
extends DefaultReactor {
    private final Logger logger = LoggerFactory.getLogger(DebugReactor.class);
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private Vertx vertx;
    @Autowired
    private VertxDebugHttpConfiguration debugHttpConfiguration;
    @Autowired
    @Qualifier(value="debugReactorHandlerRegistry")
    private ReactorHandlerRegistry reactorHandlerRegistry;

    public void onEvent(io.gravitee.common.event.Event<ReactorEvent, Reactable> reactorEvent) {
        if (reactorEvent.type() == ReactorEvent.DEBUG) {
            this.logger.debug("Try to deploy api for debug...");
            ReactableWrapper reactableWrapper = (ReactableWrapper)reactorEvent.content();
            Event debugEvent = (Event)reactableWrapper.getContent();
            DebugApi reactableDebugApi = this.toReactableDebugApi((Event)reactableWrapper.getContent());
            if (reactableDebugApi != null) {
                if (this.reactorHandlerRegistry.contains((Reactable)reactableDebugApi)) {
                    this.logger.debug("Reactable already deployed. No need to do it again.");
                    return;
                }
                this.logger.info("Deploy api for debug...");
                this.logger.debug("Creating ReactorHandler");
                this.reactorHandlerRegistry.create((Reactable)reactableDebugApi);
                try {
                    HttpRequest req = reactableDebugApi.getRequest();
                    HttpResponse response = new HttpResponse();
                    this.updateEvent(debugEvent, ApiDebugStatus.DEBUGGING);
                    this.logger.info("Sending request to debug...");
                    HttpClient httpClient = this.vertx.createHttpClient(this.buildClientOptions());
                    Future<HttpClientRequest> requestFuture = this.prepareRequest(reactableDebugApi, req, httpClient);
                    requestFuture.flatMap(reqEvent -> req.getBody() == null ? reqEvent.send() : reqEvent.send(req.getBody())).flatMap(result -> {
                        Map<String, List<String>> headers = this.convertHeaders(result.headers());
                        response.setHeaders(headers);
                        response.statusCode(result.statusCode());
                        this.logger.debug("Response status: {}", (Object)result.statusCode());
                        return result.body();
                    }).onSuccess(bodyEvent -> {
                        try {
                            response.setBody(bodyEvent.toString());
                            this.logger.debug("Response body: {}", bodyEvent);
                            reactableDebugApi.setResponse(response);
                            debugEvent.setPayload(this.objectMapper.writeValueAsString((Object)this.convert(reactableDebugApi)));
                            this.updateEvent(debugEvent, ApiDebugStatus.SUCCESS);
                            this.logger.info("Debugging successful, removing the handler.");
                        }
                        catch (JsonProcessingException | TechnicalException e) {
                            this.logger.error("Error when saving debug response...");
                            this.failEvent(debugEvent);
                        }
                        finally {
                            this.reactorHandlerRegistry.remove((Reactable)reactableDebugApi);
                            this.logger.info("The debug handler has been removed");
                        }
                    }).onFailure(throwable -> {
                        this.logger.error("Debugging API has failed, removing the handler.", throwable);
                        this.reactorHandlerRegistry.remove((Reactable)reactableDebugApi);
                        this.failEvent(debugEvent);
                    });
                }
                catch (TechnicalException e) {
                    this.logger.error("An error occurred when debugging api for event {}, removing the handler.", (Object)reactableDebugApi.getEventId(), (Object)e);
                    this.reactorHandlerRegistry.remove((Reactable)reactableDebugApi);
                    this.failEvent(debugEvent);
                }
            }
        }
    }

    private DebugApi toReactableDebugApi(Event event) {
        try {
            io.gravitee.definition.model.DebugApi eventPayload = (io.gravitee.definition.model.DebugApi)this.objectMapper.readValue(event.getPayload(), io.gravitee.definition.model.DebugApi.class);
            DebugApi debugApi = new DebugApi(event.getId(), eventPayload);
            debugApi.setEnabled(true);
            debugApi.setDeployedAt(new Date());
            return debugApi;
        }
        catch (Exception e) {
            this.logger.error("Unable to extract api definition from event [{}].", (Object)event.getId());
            this.failEvent(event);
            return null;
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.eventManager.subscribeForEvents((EventListener)this, ReactorEvent.class);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.reactorHandlerRegistry.clear();
    }

    private HttpClientOptions buildClientOptions() {
        HttpClientOptions options = new HttpClientOptions();
        options.setDefaultHost(this.debugHttpConfiguration.getHost());
        options.setDefaultPort(this.debugHttpConfiguration.getPort());
        options.setConnectTimeout(this.debugHttpConfiguration.getConnectTimeout());
        options.setTryUseCompression(this.debugHttpConfiguration.isCompressionSupported());
        options.setUseAlpn(this.debugHttpConfiguration.isAlpn());
        if (this.debugHttpConfiguration.isSecured()) {
            options.setSsl(this.debugHttpConfiguration.isSecured());
            options.setTrustAll(true);
            if (this.debugHttpConfiguration.isOpenssl()) {
                options.setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions());
            }
        }
        return options;
    }

    private Future<HttpClientRequest> prepareRequest(DebugApi debugApi, HttpRequest req, HttpClient httpClient) {
        Future future = httpClient.request(new RequestOptions().setMethod(HttpMethod.valueOf((String)req.getMethod())).setHeaders(this.buildHeaders(debugApi, req)).setURI(((VirtualHost)debugApi.getProxy().getVirtualHosts().get(0)).getPath() + req.getPath()).setTimeout((long)this.debugHttpConfiguration.getRequestTimeout())).map(httpClientRequest -> httpClientRequest.setChunked(true));
        return future;
    }

    private MultiMap buildHeaders(DebugApi debugApi, HttpRequest req) {
        String host;
        HeadersMultiMap headers = new HeadersMultiMap();
        if (debugApi.getProxy().getVirtualHosts().size() > 1 && (host = ((VirtualHost)debugApi.getProxy().getVirtualHosts().get(0)).getHost()) != null) {
            headers.add("Host", host);
        }
        return headers.addAll(this.convertHeaders(req.getHeaders()));
    }

    private void failEvent(Event debugEvent) {
        try {
            if (debugEvent != null) {
                this.updateEvent(debugEvent, ApiDebugStatus.ERROR);
            }
        }
        catch (TechnicalException e) {
            this.logger.error("Error when updating event {} with ERROR status", (Object)debugEvent.getId());
        }
    }

    private void updateEvent(Event debugEvent, ApiDebugStatus apiDebugStatus) throws TechnicalException {
        debugEvent.getProperties().put(Event.EventProperties.API_DEBUG_STATUS.getValue(), apiDebugStatus.name());
        this.eventRepository.update((Object)debugEvent);
    }

    private io.gravitee.definition.model.DebugApi convert(DebugApi content) {
        io.gravitee.definition.model.DebugApi debugAPI = new io.gravitee.definition.model.DebugApi();
        debugAPI.setName(content.getName());
        debugAPI.setId(content.getId());
        debugAPI.setDefinitionVersion(content.getDefinitionVersion());
        debugAPI.setResponse(content.getResponse());
        debugAPI.setRequest(content.getRequest());
        debugAPI.setFlowMode(content.getFlowMode());
        debugAPI.setFlows(content.getFlows());
        debugAPI.setPathMappings(content.getPathMappings());
        debugAPI.setPlans(content.getPlans());
        debugAPI.setPaths(content.getPaths());
        debugAPI.setServices(content.getServices());
        debugAPI.setProxy(content.getProxy());
        debugAPI.setProperties(content.getProperties());
        debugAPI.setResources(content.getResources());
        debugAPI.setServices(content.getServices());
        debugAPI.setResponseTemplates(content.getResponseTemplates());
        return debugAPI;
    }

    Map<String, List<String>> convertHeaders(MultiMap headersMultimap) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        if (headersMultimap != null) {
            headersMultimap.forEach(e -> headers.put((String)e.getKey(), headersMultimap.getAll((String)e.getKey())));
        }
        return headers;
    }

    MultiMap convertHeaders(Map<String, List<String>> headers) {
        HeadersMultiMap headersMultiMap = new HeadersMultiMap();
        if (headers != null) {
            headers.forEach((key, value) -> headersMultiMap.add(key, String.join((CharSequence)", ", value)));
        }
        return headersMultiMap;
    }
}

