/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.security.keyless;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.security.core.AuthenticationContext;
import io.gravitee.gateway.security.core.AuthenticationHandler;
import io.gravitee.gateway.security.core.AuthenticationPolicy;
import java.util.Collections;
import java.util.List;

public class KeylessAuthenticationHandler
implements AuthenticationHandler {
    static final String KEYLESS_POLICY = "key-less";
    private static final List<AuthenticationPolicy> POLICIES = Collections.singletonList(() -> "key-less");

    public boolean canHandle(AuthenticationContext context) {
        return !Boolean.TRUE.equals(context.getInternalAttribute("auth.tokenIdentifiedInRequest"));
    }

    public String name() {
        return "key_less";
    }

    public int order() {
        return 1000;
    }

    public List<AuthenticationPolicy> handle(ExecutionContext executionContext) {
        return POLICIES;
    }

    public String tokenType() {
        return "None";
    }
}

