/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.security.jwt;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.security.core.AuthenticationContext;
import io.gravitee.gateway.security.core.AuthenticationHandler;
import io.gravitee.gateway.security.core.AuthenticationPolicy;
import io.gravitee.gateway.security.core.LazyJwtToken;
import io.gravitee.gateway.security.jwt.policy.CheckSubscriptionPolicy;
import io.gravitee.policy.jwt.utils.TokenExtractor;
import java.util.Arrays;
import java.util.List;

public class JWTAuthenticationHandler
implements AuthenticationHandler {
    static final String AUTHENTICATION_HANDLER_NAME = "jwt";
    static final String JWT_CONTEXT_ATTRIBUTE = "jwt";
    private static final List<AuthenticationPolicy> POLICIES = Arrays.asList(() -> "jwt", () -> CheckSubscriptionPolicy.class);

    public boolean canHandle(AuthenticationContext context) {
        String token = TokenExtractor.extract((Request)context.request());
        if (token == null) {
            return false;
        }
        context.setInternalAttribute("auth.tokenIdentifiedInRequest", (Object)true);
        if (context.get("jwt") == null) {
            context.set("jwt", (Object)new LazyJwtToken(token));
        }
        return true;
    }

    public String name() {
        return "jwt";
    }

    public int order() {
        return 0;
    }

    public List<AuthenticationPolicy> handle(ExecutionContext executionContext) {
        return POLICIES;
    }

    public String tokenType() {
        return "AuthorizationBearer";
    }
}

