/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.platform.organization.manager;

import io.gravitee.common.event.EventManager;
import io.gravitee.gateway.platform.organization.ReactableOrganization;
import io.gravitee.gateway.platform.organization.event.OrganizationEvent;
import io.gravitee.gateway.platform.organization.manager.OrganizationManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOrganizationManager
implements OrganizationManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultOrganizationManager.class);
    private final Map<String, ReactableOrganization> organizations = new ConcurrentHashMap<String, ReactableOrganization>();
    private final EventManager eventManager;

    @Override
    public boolean register(ReactableOrganization reactableOrganization) {
        if (this.isRegistrable(reactableOrganization)) {
            log.info("Register organization {}", (Object)reactableOrganization);
            this.organizations.put(reactableOrganization.getId(), reactableOrganization);
            this.eventManager.publishEvent((Enum)OrganizationEvent.REGISTER, (Object)reactableOrganization);
            return true;
        }
        return false;
    }

    private boolean isRegistrable(ReactableOrganization reactableOrganization) {
        ReactableOrganization registeredReactableOrganization = this.organizations.get(reactableOrganization.getId());
        return registeredReactableOrganization == null || !registeredReactableOrganization.equals(reactableOrganization) || registeredReactableOrganization.getDeployedAt() == null || registeredReactableOrganization.getDeployedAt().before(reactableOrganization.getDeployedAt());
    }

    @Override
    public void unregister(String organizationId) {
        ReactableOrganization removed = this.organizations.remove(organizationId);
        if (removed != null) {
            log.info("Unregister organization {}", (Object)organizationId);
            this.eventManager.publishEvent((Enum)OrganizationEvent.UNREGISTER, (Object)removed);
        }
    }

    @Override
    public ReactableOrganization getOrganization(String organizationId) {
        if (organizationId != null) {
            return this.organizations.get(organizationId);
        }
        return null;
    }

    @Generated
    public DefaultOrganizationManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

