/*
 * Copyright © 2015 The Gravitee team (http://gravitee.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gravitee.gateway.buffer.netty;

import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.buffer.BufferFactory;
import io.netty.buffer.ByteBuf;

/**
 * @author David BRASSELY (david at gravitee.io)
 * @author GraviteeSource Team
 */
public class BufferFactoryImpl implements BufferFactory {

    @Override
    public Buffer buffer(ByteBuf nativeBuffer) {
        return new BufferImpl(nativeBuffer);
    }

    @Override
    public Buffer buffer(io.vertx.core.buffer.Buffer vertxBuffer) {
        return new BufferImpl(vertxBuffer.getByteBuf());
    }

    @Override
    public Buffer buffer(io.vertx.rxjava3.core.buffer.Buffer vertxBuffer) {
        return new BufferImpl(vertxBuffer.getByteBuf());
    }

    @Override
    public Buffer buffer(int initialSizeHint) {
        return new BufferImpl(initialSizeHint);
    }

    @Override
    public Buffer buffer() {
        return new BufferImpl();
    }

    @Override
    public Buffer buffer(String str) {
        return new BufferImpl(str);
    }

    @Override
    public Buffer buffer(String str, String enc) {
        return new BufferImpl(str, enc);
    }

    @Override
    public Buffer buffer(byte[] bytes) {
        return new BufferImpl(bytes);
    }
}
