/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model.v4.plan;

import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import lombok.Generated;

@Schema(name="PlanStatusV4")
public enum PlanStatus {
    STAGING("staging"),
    PUBLISHED("published"),
    DEPRECATED("deprecated"),
    CLOSED("closed");

    private static final Map<String, PlanStatus> maps;
    @JsonValue
    private final String label;

    public static PlanStatus valueOfLabel(String label) {
        if (label != null) {
            PlanStatus planStatus = maps.get(label);
            if (planStatus == null) {
                try {
                    planStatus = PlanStatus.valueOf(label);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return planStatus;
        }
        return null;
    }

    @Generated
    private PlanStatus(String label) {
        this.label = label;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    static {
        maps = Map.of(PlanStatus.STAGING.label, STAGING, PlanStatus.PUBLISHED.label, PUBLISHED, PlanStatus.DEPRECATED.label, DEPRECATED, PlanStatus.CLOSED.label, CLOSED);
    }
}

