/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model.v4.plan;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import lombok.Generated;

@Schema(name="PlanV4")
public class Plan
implements Serializable {
    @JsonProperty(required=true)
    @NotBlank
    private String id;
    @JsonProperty(required=true)
    @NotBlank
    private String name;
    @JsonProperty(required=true)
    @NotNull
    private PlanSecurity security;
    @JsonProperty(required=true)
    @NotNull
    private PlanMode mode;
    private String selectionRule;
    private List<Flow> flows;
    private Set<String> tags;
    @JsonProperty(required=true)
    @NotNull
    private PlanStatus status;

    public final boolean isSubscribable() {
        return this.getSecurity() != null && this.getSecurity().getType() != null && !"KEY_LESS".equalsIgnoreCase(this.getSecurity().getType()) || this.usePushMode();
    }

    public final boolean usePushMode() {
        return this.getMode() != null && this.getMode() == PlanMode.PUSH;
    }

    public final boolean useStandardMode() {
        return this.getMode() != null && this.getMode() == PlanMode.STANDARD;
    }

    public final boolean isApiKey() {
        return this.getSecurity() != null && ("API_KEY".equalsIgnoreCase(this.getSecurity().getType()) || "api-key".equalsIgnoreCase(this.getSecurity().getType()));
    }

    @Generated
    public static PlanBuilder builder() {
        return new PlanBuilder();
    }

    @Generated
    public Plan() {
    }

    @Generated
    public Plan(String id, String name, PlanSecurity security, PlanMode mode, String selectionRule, List<Flow> flows, Set<String> tags, PlanStatus status) {
        this.id = id;
        this.name = name;
        this.security = security;
        this.mode = mode;
        this.selectionRule = selectionRule;
        this.flows = flows;
        this.tags = tags;
        this.status = status;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public PlanSecurity getSecurity() {
        return this.security;
    }

    @Generated
    public PlanMode getMode() {
        return this.mode;
    }

    @Generated
    public String getSelectionRule() {
        return this.selectionRule;
    }

    @Generated
    public List<Flow> getFlows() {
        return this.flows;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public PlanStatus getStatus() {
        return this.status;
    }

    @JsonProperty(required=true)
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(required=true)
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(required=true)
    @Generated
    public void setSecurity(PlanSecurity security) {
        this.security = security;
    }

    @JsonProperty(required=true)
    @Generated
    public void setMode(PlanMode mode) {
        this.mode = mode;
    }

    @Generated
    public void setSelectionRule(String selectionRule) {
        this.selectionRule = selectionRule;
    }

    @Generated
    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @JsonProperty(required=true)
    @Generated
    public void setStatus(PlanStatus status) {
        this.status = status;
    }

    @Generated
    public String toString() {
        return "Plan(id=" + this.getId() + ", name=" + this.getName() + ", security=" + this.getSecurity() + ", mode=" + this.getMode() + ", selectionRule=" + this.getSelectionRule() + ", flows=" + this.getFlows() + ", tags=" + this.getTags() + ", status=" + this.getStatus() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plan)) {
            return false;
        }
        Plan other = (Plan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        PlanSecurity this$security = this.getSecurity();
        PlanSecurity other$security = other.getSecurity();
        if (this$security == null ? other$security != null : !((Object)this$security).equals(other$security)) {
            return false;
        }
        PlanMode this$mode = this.getMode();
        PlanMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        String this$selectionRule = this.getSelectionRule();
        String other$selectionRule = other.getSelectionRule();
        if (this$selectionRule == null ? other$selectionRule != null : !this$selectionRule.equals(other$selectionRule)) {
            return false;
        }
        List<Flow> this$flows = this.getFlows();
        List<Flow> other$flows = other.getFlows();
        if (this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        PlanStatus this$status = this.getStatus();
        PlanStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Plan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        PlanSecurity $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : ((Object)$security).hashCode());
        PlanMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        String $selectionRule = this.getSelectionRule();
        result = result * 59 + ($selectionRule == null ? 43 : $selectionRule.hashCode());
        List<Flow> $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        PlanStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    @Generated
    public static class PlanBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private PlanSecurity security;
        @Generated
        private PlanMode mode;
        @Generated
        private String selectionRule;
        @Generated
        private List<Flow> flows;
        @Generated
        private Set<String> tags;
        @Generated
        private PlanStatus status;

        @Generated
        PlanBuilder() {
        }

        @JsonProperty(required=true)
        @Generated
        public PlanBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(required=true)
        @Generated
        public PlanBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(required=true)
        @Generated
        public PlanBuilder security(PlanSecurity security) {
            this.security = security;
            return this;
        }

        @JsonProperty(required=true)
        @Generated
        public PlanBuilder mode(PlanMode mode) {
            this.mode = mode;
            return this;
        }

        @Generated
        public PlanBuilder selectionRule(String selectionRule) {
            this.selectionRule = selectionRule;
            return this;
        }

        @Generated
        public PlanBuilder flows(List<Flow> flows) {
            this.flows = flows;
            return this;
        }

        @Generated
        public PlanBuilder tags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        @JsonProperty(required=true)
        @Generated
        public PlanBuilder status(PlanStatus status) {
            this.status = status;
            return this;
        }

        @Generated
        public Plan build() {
            return new Plan(this.id, this.name, this.security, this.mode, this.selectionRule, this.flows, this.tags, this.status);
        }

        @Generated
        public String toString() {
            return "Plan.PlanBuilder(id=" + this.id + ", name=" + this.name + ", security=" + this.security + ", mode=" + this.mode + ", selectionRule=" + this.selectionRule + ", flows=" + this.flows + ", tags=" + this.tags + ", status=" + this.status + ")";
        }
    }
}

