/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model.v4.listener.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.gravitee.definition.model.Cors;
import io.gravitee.definition.model.PathMapping;
import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.listener.http.Path;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;

@Schema(name="HttpListenerV4")
public class HttpListener
extends Listener {
    @NotEmpty
    @NotNull
    private List<Path> paths;
    private Set<String> pathMappings;
    @JsonIgnore
    private Map<String, Pattern> pathMappingsPattern;
    private Cors cors;

    public HttpListener() {
        super(ListenerType.HTTP);
    }

    protected HttpListener(HttpListenerBuilder<?, ?> b) {
        super(ListenerType.HTTP, b);
        this.paths = b.paths;
        this.pathMappings = b.pathMappings;
        this.pathMappingsPattern = b.pathMappingsPattern;
        this.cors = b.cors;
    }

    public void setPathMappings(Set<String> pathMappings) {
        this.pathMappings = pathMappings;
        if (pathMappings != null) {
            this.setPathMappingsPattern(pathMappings.stream().collect(Collectors.toMap(Function.identity(), PathMapping::buildPattern)));
        }
    }

    @Generated
    public static HttpListenerBuilder<?, ?> builder() {
        return new HttpListenerBuilderImpl();
    }

    @Generated
    public HttpListenerBuilder<?, ?> toBuilder() {
        return new HttpListenerBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public List<Path> getPaths() {
        return this.paths;
    }

    @Generated
    public Set<String> getPathMappings() {
        return this.pathMappings;
    }

    @Generated
    public Map<String, Pattern> getPathMappingsPattern() {
        return this.pathMappingsPattern;
    }

    @Generated
    public Cors getCors() {
        return this.cors;
    }

    @Generated
    public void setPaths(List<Path> paths) {
        this.paths = paths;
    }

    @JsonIgnore
    @Generated
    public void setPathMappingsPattern(Map<String, Pattern> pathMappingsPattern) {
        this.pathMappingsPattern = pathMappingsPattern;
    }

    @Generated
    public void setCors(Cors cors) {
        this.cors = cors;
    }

    @Override
    @Generated
    public String toString() {
        return "HttpListener(super=" + super.toString() + ", paths=" + this.getPaths() + ", pathMappings=" + this.getPathMappings() + ", pathMappingsPattern=" + this.getPathMappingsPattern() + ", cors=" + this.getCors() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpListener)) {
            return false;
        }
        HttpListener other = (HttpListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Path> this$paths = this.getPaths();
        List<Path> other$paths = other.getPaths();
        if (this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths)) {
            return false;
        }
        Set<String> this$pathMappings = this.getPathMappings();
        Set<String> other$pathMappings = other.getPathMappings();
        if (this$pathMappings == null ? other$pathMappings != null : !((Object)this$pathMappings).equals(other$pathMappings)) {
            return false;
        }
        Map<String, Pattern> this$pathMappingsPattern = this.getPathMappingsPattern();
        Map<String, Pattern> other$pathMappingsPattern = other.getPathMappingsPattern();
        if (this$pathMappingsPattern == null ? other$pathMappingsPattern != null : !((Object)this$pathMappingsPattern).equals(other$pathMappingsPattern)) {
            return false;
        }
        Cors this$cors = this.getCors();
        Cors other$cors = other.getCors();
        return !(this$cors == null ? other$cors != null : !((Object)this$cors).equals(other$cors));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpListener;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Path> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        Set<String> $pathMappings = this.getPathMappings();
        result = result * 59 + ($pathMappings == null ? 43 : ((Object)$pathMappings).hashCode());
        Map<String, Pattern> $pathMappingsPattern = this.getPathMappingsPattern();
        result = result * 59 + ($pathMappingsPattern == null ? 43 : ((Object)$pathMappingsPattern).hashCode());
        Cors $cors = this.getCors();
        result = result * 59 + ($cors == null ? 43 : ((Object)$cors).hashCode());
        return result;
    }

    @Generated
    public static abstract class HttpListenerBuilder<C extends HttpListener, B extends HttpListenerBuilder<C, B>>
    extends Listener.ListenerBuilder<C, B> {
        @Generated
        private List<Path> paths;
        @Generated
        private Set<String> pathMappings;
        @Generated
        private Map<String, Pattern> pathMappingsPattern;
        @Generated
        private Cors cors;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            HttpListenerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(HttpListener instance, HttpListenerBuilder<?, ?> b) {
            b.paths(instance.paths);
            b.pathMappings(instance.pathMappings);
            b.pathMappingsPattern(instance.pathMappingsPattern);
            b.cors(instance.cors);
        }

        @Generated
        public B paths(List<Path> paths) {
            this.paths = paths;
            return (B)this.self();
        }

        @Generated
        public B pathMappings(Set<String> pathMappings) {
            this.pathMappings = pathMappings;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B pathMappingsPattern(Map<String, Pattern> pathMappingsPattern) {
            this.pathMappingsPattern = pathMappingsPattern;
            return (B)this.self();
        }

        @Generated
        public B cors(Cors cors) {
            this.cors = cors;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "HttpListener.HttpListenerBuilder(super=" + super.toString() + ", paths=" + this.paths + ", pathMappings=" + this.pathMappings + ", pathMappingsPattern=" + this.pathMappingsPattern + ", cors=" + this.cors + ")";
        }
    }

    @Generated
    private static final class HttpListenerBuilderImpl
    extends HttpListenerBuilder<HttpListener, HttpListenerBuilderImpl> {
        @Generated
        private HttpListenerBuilderImpl() {
        }

        @Override
        @Generated
        protected HttpListenerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public HttpListener build() {
            return new HttpListener(this);
        }
    }
}

