/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model.v4.listener;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.listener.entrypoint.Entrypoint;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.definition.model.v4.listener.subscription.SubscriptionListener;
import io.gravitee.definition.model.v4.listener.tcp.TcpListener;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=HttpListener.class, name="http"), @JsonSubTypes.Type(value=SubscriptionListener.class, name="subscription"), @JsonSubTypes.Type(value=TcpListener.class, name="tcp")})
@Schema(name="ListenerV4", discriminatorProperty="type", discriminatorMapping={@DiscriminatorMapping(value="http", schema=HttpListener.class), @DiscriminatorMapping(value="tcp", schema=TcpListener.class), @DiscriminatorMapping(value="subscription", schema=SubscriptionListener.class)}, oneOf={HttpListener.class, TcpListener.class, SubscriptionListener.class})
public abstract class Listener
implements Serializable {
    public static final String HTTP_LABEL = "http";
    public static final String SUBSCRIPTION_LABEL = "subscription";
    public static final String TCP_LABEL = "tcp";
    @JsonProperty(required=true)
    @NotNull
    private ListenerType type;
    @NotEmpty
    private List<Entrypoint> entrypoints;
    private List<String> servers;

    protected Listener(ListenerType type) {
        this.type = type;
    }

    protected Listener(ListenerType type, ListenerBuilder<?, ?> b) {
        this.type = type;
        this.entrypoints = b.entrypoints;
        this.servers = b.servers;
    }

    protected Listener(ListenerBuilder<?, ?> b) {
        this.type = b.type;
        this.entrypoints = b.entrypoints;
        this.servers = b.servers;
    }

    @Generated
    public Listener() {
    }

    @Generated
    public ListenerType getType() {
        return this.type;
    }

    @Generated
    public List<Entrypoint> getEntrypoints() {
        return this.entrypoints;
    }

    @Generated
    public List<String> getServers() {
        return this.servers;
    }

    @JsonProperty(required=true)
    @Generated
    public void setType(ListenerType type) {
        this.type = type;
    }

    @Generated
    public void setEntrypoints(List<Entrypoint> entrypoints) {
        this.entrypoints = entrypoints;
    }

    @Generated
    public void setServers(List<String> servers) {
        this.servers = servers;
    }

    @Generated
    public String toString() {
        return "Listener(type=" + this.getType() + ", entrypoints=" + this.getEntrypoints() + ", servers=" + this.getServers() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Listener)) {
            return false;
        }
        Listener other = (Listener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ListenerType this$type = this.getType();
        ListenerType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<Entrypoint> this$entrypoints = this.getEntrypoints();
        List<Entrypoint> other$entrypoints = other.getEntrypoints();
        if (this$entrypoints == null ? other$entrypoints != null : !((Object)this$entrypoints).equals(other$entrypoints)) {
            return false;
        }
        List<String> this$servers = this.getServers();
        List<String> other$servers = other.getServers();
        return !(this$servers == null ? other$servers != null : !((Object)this$servers).equals(other$servers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Listener;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ListenerType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<Entrypoint> $entrypoints = this.getEntrypoints();
        result = result * 59 + ($entrypoints == null ? 43 : ((Object)$entrypoints).hashCode());
        List<String> $servers = this.getServers();
        result = result * 59 + ($servers == null ? 43 : ((Object)$servers).hashCode());
        return result;
    }

    @Generated
    public static abstract class ListenerBuilder<C extends Listener, B extends ListenerBuilder<C, B>> {
        @Generated
        private ListenerType type;
        @Generated
        private List<Entrypoint> entrypoints;
        @Generated
        private List<String> servers;

        @Generated
        protected B $fillValuesFrom(C instance) {
            ListenerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Listener instance, ListenerBuilder<?, ?> b) {
            b.type(instance.type);
            b.entrypoints(instance.entrypoints);
            b.servers(instance.servers);
        }

        @JsonProperty(required=true)
        @Generated
        public B type(ListenerType type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B entrypoints(List<Entrypoint> entrypoints) {
            this.entrypoints = entrypoints;
            return this.self();
        }

        @Generated
        public B servers(List<String> servers) {
            this.servers = servers;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Listener.ListenerBuilder(type=" + this.type + ", entrypoints=" + this.entrypoints + ", servers=" + this.servers + ")";
        }
    }
}

