/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model.v4.flow.selector;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.gravitee.definition.model.flow.Operator;
import io.gravitee.definition.model.v4.ConnectorMode;
import io.gravitee.definition.model.v4.flow.selector.Selector;
import io.gravitee.definition.model.v4.flow.selector.SelectorType;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

@Schema(name="ChannelSelectorV4")
public class ChannelSelector
extends Selector {
    protected static final String DEFAULT_CHANNEL = "/";
    protected static final Operator DEFAULT_OPERATOR = Operator.STARTS_WITH;
    private Set<@NotNull Operation> operations;
    @JsonProperty(required=true)
    @NotEmpty
    private String channel;
    @JsonProperty(required=true)
    @NotNull
    private Operator channelOperator;
    private Set<String> entrypoints;

    @JsonGetter(value="entrypoints")
    private List<String> getSortedEntrypoints() {
        if (this.entrypoints != null) {
            ArrayList<String> listOfEntrypoints = new ArrayList<String>(this.entrypoints);
            Collections.sort(listOfEntrypoints);
            return listOfEntrypoints;
        }
        return null;
    }

    public ChannelSelector() {
        super(SelectorType.CHANNEL);
        this.channel = DEFAULT_CHANNEL;
        this.channelOperator = DEFAULT_OPERATOR;
    }

    @Generated
    private static String $default$channel() {
        return DEFAULT_CHANNEL;
    }

    @Generated
    private static Operator $default$channelOperator() {
        return Operator.STARTS_WITH;
    }

    @Generated
    protected ChannelSelector(ChannelSelectorBuilder<?, ?> b) {
        super(b);
        this.operations = b.operations;
        this.channel = b.channel$set ? b.channel$value : ChannelSelector.$default$channel();
        this.channelOperator = b.channelOperator$set ? b.channelOperator$value : ChannelSelector.$default$channelOperator();
        this.entrypoints = b.entrypoints;
    }

    @Generated
    public static ChannelSelectorBuilder<?, ?> builder() {
        return new ChannelSelectorBuilderImpl();
    }

    @Generated
    public ChannelSelectorBuilder<?, ?> toBuilder() {
        return new ChannelSelectorBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Set<@NotNull Operation> getOperations() {
        return this.operations;
    }

    @Generated
    public String getChannel() {
        return this.channel;
    }

    @Generated
    public Operator getChannelOperator() {
        return this.channelOperator;
    }

    @Generated
    public Set<String> getEntrypoints() {
        return this.entrypoints;
    }

    @Generated
    public void setOperations(Set<@NotNull Operation> operations) {
        this.operations = operations;
    }

    @JsonProperty(required=true)
    @Generated
    public void setChannel(String channel) {
        this.channel = channel;
    }

    @JsonProperty(required=true)
    @Generated
    public void setChannelOperator(Operator channelOperator) {
        this.channelOperator = channelOperator;
    }

    @Generated
    public void setEntrypoints(Set<String> entrypoints) {
        this.entrypoints = entrypoints;
    }

    @Override
    @Generated
    public String toString() {
        return "ChannelSelector(super=" + super.toString() + ", operations=" + this.getOperations() + ", channel=" + this.getChannel() + ", channelOperator=" + this.getChannelOperator() + ", entrypoints=" + this.getEntrypoints() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelSelector)) {
            return false;
        }
        ChannelSelector other = (ChannelSelector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set<Operation> this$operations = this.getOperations();
        Set<Operation> other$operations = other.getOperations();
        if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        Operator this$channelOperator = this.getChannelOperator();
        Operator other$channelOperator = other.getChannelOperator();
        if (this$channelOperator == null ? other$channelOperator != null : !this$channelOperator.equals(other$channelOperator)) {
            return false;
        }
        Set<String> this$entrypoints = this.getEntrypoints();
        Set<String> other$entrypoints = other.getEntrypoints();
        return !(this$entrypoints == null ? other$entrypoints != null : !((Object)this$entrypoints).equals(other$entrypoints));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChannelSelector;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set<Operation> $operations = this.getOperations();
        result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        Operator $channelOperator = this.getChannelOperator();
        result = result * 59 + ($channelOperator == null ? 43 : $channelOperator.hashCode());
        Set<String> $entrypoints = this.getEntrypoints();
        result = result * 59 + ($entrypoints == null ? 43 : ((Object)$entrypoints).hashCode());
        return result;
    }

    public static abstract class ChannelSelectorBuilder<C extends ChannelSelector, B extends ChannelSelectorBuilder<C, B>>
    extends Selector.SelectorBuilder<C, B> {
        @Generated
        private Set<@NotNull Operation> operations;
        @Generated
        private boolean channel$set;
        @Generated
        private String channel$value;
        @Generated
        private boolean channelOperator$set;
        @Generated
        private Operator channelOperator$value;
        @Generated
        private Set<String> entrypoints;

        ChannelSelectorBuilder() {
            this.type(SelectorType.CHANNEL);
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ChannelSelectorBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ChannelSelector instance, ChannelSelectorBuilder<?, ?> b) {
            b.operations(instance.operations);
            b.channel(instance.channel);
            b.channelOperator(instance.channelOperator);
            b.entrypoints(instance.entrypoints);
        }

        @Generated
        public B operations(Set<@NotNull Operation> operations) {
            this.operations = operations;
            return (B)this.self();
        }

        @JsonProperty(required=true)
        @Generated
        public B channel(String channel) {
            this.channel$value = channel;
            this.channel$set = true;
            return (B)this.self();
        }

        @JsonProperty(required=true)
        @Generated
        public B channelOperator(Operator channelOperator) {
            this.channelOperator$value = channelOperator;
            this.channelOperator$set = true;
            return (B)this.self();
        }

        @Generated
        public B entrypoints(Set<String> entrypoints) {
            this.entrypoints = entrypoints;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ChannelSelector.ChannelSelectorBuilder(super=" + super.toString() + ", operations=" + this.operations + ", channel$value=" + this.channel$value + ", channelOperator$value=" + this.channelOperator$value + ", entrypoints=" + this.entrypoints + ")";
        }
    }

    @Generated
    private static final class ChannelSelectorBuilderImpl
    extends ChannelSelectorBuilder<ChannelSelector, ChannelSelectorBuilderImpl> {
        @Generated
        private ChannelSelectorBuilderImpl() {
        }

        @Override
        @Generated
        protected ChannelSelectorBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ChannelSelector build() {
            return new ChannelSelector(this);
        }
    }

    @Schema(name="ChannelSelectorOperationV4")
    public static enum Operation {
        SUBSCRIBE(ConnectorMode.SUBSCRIBE.getLabel(), ConnectorMode.SUBSCRIBE),
        PUBLISH(ConnectorMode.PUBLISH.getLabel(), ConnectorMode.PUBLISH);

        private static final Map<ConnectorMode, Operation> MAP;
        @JsonValue
        private final String label;
        @JsonIgnore
        private final ConnectorMode connectorMode;

        public static Operation fromConnectorMode(ConnectorMode connectorMode) {
            if (connectorMode != null) {
                return MAP.get((Object)connectorMode);
            }
            return null;
        }

        @Generated
        private Operation(String label, ConnectorMode connectorMode) {
            this.label = label;
            this.connectorMode = connectorMode;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public ConnectorMode getConnectorMode() {
            return this.connectorMode;
        }

        static {
            MAP = Map.of(Operation.SUBSCRIBE.connectorMode, SUBSCRIBE, Operation.PUBLISH.connectorMode, PUBLISH);
        }
    }
}

