/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model.v4.flow;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.gravitee.definition.model.v4.flow.selector.Selector;
import io.gravitee.definition.model.v4.flow.selector.SelectorType;
import io.gravitee.definition.model.v4.flow.step.Step;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

@Schema(name="FlowV4")
public class Flow
implements Serializable {
    private String id;
    private String name;
    private boolean enabled;
    @Valid
    private List<Selector> selectors;
    @Valid
    private List<Step> request;
    @Valid
    private List<Step> response;
    @Valid
    private List<Step> subscribe;
    @Valid
    private List<Step> publish;
    private Set<@NotEmpty String> tags;

    @JsonIgnore
    public Optional<Selector> selectorByType(SelectorType type) {
        if (this.selectors != null) {
            return this.selectors.stream().filter(selector -> selector.getType() == type).findFirst();
        }
        return Optional.empty();
    }

    @Generated
    private static boolean $default$enabled() {
        return true;
    }

    @Generated
    public static FlowBuilder builder() {
        return new FlowBuilder();
    }

    @Generated
    public FlowBuilder toBuilder() {
        return new FlowBuilder().id(this.id).name(this.name).enabled(this.enabled).selectors(this.selectors).request(this.request).response(this.response).subscribe(this.subscribe).publish(this.publish).tags(this.tags);
    }

    @Generated
    public Flow() {
        this.enabled = Flow.$default$enabled();
    }

    @Generated
    public Flow(String id, String name, boolean enabled, List<Selector> selectors, List<Step> request, List<Step> response, List<Step> subscribe, List<Step> publish, Set<@NotEmpty String> tags) {
        this.id = id;
        this.name = name;
        this.enabled = enabled;
        this.selectors = selectors;
        this.request = request;
        this.response = response;
        this.subscribe = subscribe;
        this.publish = publish;
        this.tags = tags;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public List<Selector> getSelectors() {
        return this.selectors;
    }

    @Generated
    public List<Step> getRequest() {
        return this.request;
    }

    @Generated
    public List<Step> getResponse() {
        return this.response;
    }

    @Generated
    public List<Step> getSubscribe() {
        return this.subscribe;
    }

    @Generated
    public List<Step> getPublish() {
        return this.publish;
    }

    @Generated
    public Set<@NotEmpty String> getTags() {
        return this.tags;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setSelectors(List<Selector> selectors) {
        this.selectors = selectors;
    }

    @Generated
    public void setRequest(List<Step> request) {
        this.request = request;
    }

    @Generated
    public void setResponse(List<Step> response) {
        this.response = response;
    }

    @Generated
    public void setSubscribe(List<Step> subscribe) {
        this.subscribe = subscribe;
    }

    @Generated
    public void setPublish(List<Step> publish) {
        this.publish = publish;
    }

    @Generated
    public void setTags(Set<@NotEmpty String> tags) {
        this.tags = tags;
    }

    @Generated
    public String toString() {
        return "Flow(id=" + this.getId() + ", name=" + this.getName() + ", enabled=" + this.isEnabled() + ", selectors=" + this.getSelectors() + ", request=" + this.getRequest() + ", response=" + this.getResponse() + ", subscribe=" + this.getSubscribe() + ", publish=" + this.getPublish() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Selector> this$selectors = this.getSelectors();
        List<Selector> other$selectors = other.getSelectors();
        if (this$selectors == null ? other$selectors != null : !((Object)this$selectors).equals(other$selectors)) {
            return false;
        }
        List<Step> this$request = this.getRequest();
        List<Step> other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        List<Step> this$response = this.getResponse();
        List<Step> other$response = other.getResponse();
        if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
            return false;
        }
        List<Step> this$subscribe = this.getSubscribe();
        List<Step> other$subscribe = other.getSubscribe();
        if (this$subscribe == null ? other$subscribe != null : !((Object)this$subscribe).equals(other$subscribe)) {
            return false;
        }
        List<Step> this$publish = this.getPublish();
        List<Step> other$publish = other.getPublish();
        if (this$publish == null ? other$publish != null : !((Object)this$publish).equals(other$publish)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Flow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Selector> $selectors = this.getSelectors();
        result = result * 59 + ($selectors == null ? 43 : ((Object)$selectors).hashCode());
        List<Step> $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        List<Step> $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
        List<Step> $subscribe = this.getSubscribe();
        result = result * 59 + ($subscribe == null ? 43 : ((Object)$subscribe).hashCode());
        List<Step> $publish = this.getPublish();
        result = result * 59 + ($publish == null ? 43 : ((Object)$publish).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Generated
    public Flow withId(String id) {
        return this.id == id ? this : new Flow(id, this.name, this.enabled, this.selectors, this.request, this.response, this.subscribe, this.publish, this.tags);
    }

    @Generated
    public Flow withName(String name) {
        return this.name == name ? this : new Flow(this.id, name, this.enabled, this.selectors, this.request, this.response, this.subscribe, this.publish, this.tags);
    }

    @Generated
    public Flow withEnabled(boolean enabled) {
        return this.enabled == enabled ? this : new Flow(this.id, this.name, enabled, this.selectors, this.request, this.response, this.subscribe, this.publish, this.tags);
    }

    @Generated
    public Flow withSelectors(List<Selector> selectors) {
        return this.selectors == selectors ? this : new Flow(this.id, this.name, this.enabled, selectors, this.request, this.response, this.subscribe, this.publish, this.tags);
    }

    @Generated
    public Flow withRequest(List<Step> request) {
        return this.request == request ? this : new Flow(this.id, this.name, this.enabled, this.selectors, request, this.response, this.subscribe, this.publish, this.tags);
    }

    @Generated
    public Flow withResponse(List<Step> response) {
        return this.response == response ? this : new Flow(this.id, this.name, this.enabled, this.selectors, this.request, response, this.subscribe, this.publish, this.tags);
    }

    @Generated
    public Flow withSubscribe(List<Step> subscribe) {
        return this.subscribe == subscribe ? this : new Flow(this.id, this.name, this.enabled, this.selectors, this.request, this.response, subscribe, this.publish, this.tags);
    }

    @Generated
    public Flow withPublish(List<Step> publish) {
        return this.publish == publish ? this : new Flow(this.id, this.name, this.enabled, this.selectors, this.request, this.response, this.subscribe, publish, this.tags);
    }

    @Generated
    public Flow withTags(Set<@NotEmpty String> tags) {
        return this.tags == tags ? this : new Flow(this.id, this.name, this.enabled, this.selectors, this.request, this.response, this.subscribe, this.publish, tags);
    }

    @Generated
    public static class FlowBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private boolean enabled$set;
        @Generated
        private boolean enabled$value;
        @Generated
        private List<Selector> selectors;
        @Generated
        private List<Step> request;
        @Generated
        private List<Step> response;
        @Generated
        private List<Step> subscribe;
        @Generated
        private List<Step> publish;
        @Generated
        private Set<@NotEmpty String> tags;

        @Generated
        FlowBuilder() {
        }

        @Generated
        public FlowBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public FlowBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public FlowBuilder enabled(boolean enabled) {
            this.enabled$value = enabled;
            this.enabled$set = true;
            return this;
        }

        @Generated
        public FlowBuilder selectors(List<Selector> selectors) {
            this.selectors = selectors;
            return this;
        }

        @Generated
        public FlowBuilder request(List<Step> request) {
            this.request = request;
            return this;
        }

        @Generated
        public FlowBuilder response(List<Step> response) {
            this.response = response;
            return this;
        }

        @Generated
        public FlowBuilder subscribe(List<Step> subscribe) {
            this.subscribe = subscribe;
            return this;
        }

        @Generated
        public FlowBuilder publish(List<Step> publish) {
            this.publish = publish;
            return this;
        }

        @Generated
        public FlowBuilder tags(Set<@NotEmpty String> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public Flow build() {
            boolean enabled$value = this.enabled$value;
            if (!this.enabled$set) {
                enabled$value = Flow.$default$enabled();
            }
            return new Flow(this.id, this.name, enabled$value, this.selectors, this.request, this.response, this.subscribe, this.publish, this.tags);
        }

        @Generated
        public String toString() {
            return "Flow.FlowBuilder(id=" + this.id + ", name=" + this.name + ", enabled$value=" + this.enabled$value + ", selectors=" + this.selectors + ", request=" + this.request + ", response=" + this.response + ", subscribe=" + this.subscribe + ", publish=" + this.publish + ", tags=" + this.tags + ")";
        }
    }
}

