/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model.v4.endpointgroup;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.model.v4.endpointgroup.Endpoint;
import io.gravitee.definition.model.v4.endpointgroup.loadbalancer.LoadBalancer;
import io.gravitee.definition.model.v4.endpointgroup.service.EndpointGroupServices;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;

@Schema(name="EndpointGroupV4")
public class EndpointGroup
implements Serializable {
    @NotBlank
    private String name;
    @JsonProperty(required=true)
    @NotBlank
    private String type;
    private LoadBalancer loadBalancer;
    @Schema(implementation=Object.class)
    @JsonRawValue
    private String sharedConfiguration;
    @Valid
    private List<Endpoint> endpoints;
    private EndpointGroupServices services;

    @JsonSetter
    public void setSharedConfiguration(JsonNode configuration) {
        if (configuration != null) {
            this.sharedConfiguration = configuration.toString();
        }
    }

    public void setSharedConfiguration(String sharedConfiguration) {
        this.sharedConfiguration = sharedConfiguration;
    }

    @Generated
    private static LoadBalancer $default$loadBalancer() {
        return new LoadBalancer();
    }

    @Generated
    private static EndpointGroupServices $default$services() {
        return new EndpointGroupServices();
    }

    @Generated
    public static EndpointGroupBuilder builder() {
        return new EndpointGroupBuilder();
    }

    @Generated
    public EndpointGroup(String name, String type, LoadBalancer loadBalancer, String sharedConfiguration, List<Endpoint> endpoints, EndpointGroupServices services) {
        this.name = name;
        this.type = type;
        this.loadBalancer = loadBalancer;
        this.sharedConfiguration = sharedConfiguration;
        this.endpoints = endpoints;
        this.services = services;
    }

    @Generated
    public EndpointGroup() {
        this.loadBalancer = EndpointGroup.$default$loadBalancer();
        this.services = EndpointGroup.$default$services();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    @Generated
    public String getSharedConfiguration() {
        return this.sharedConfiguration;
    }

    @Generated
    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Generated
    public EndpointGroupServices getServices() {
        return this.services;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(required=true)
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    @Generated
    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @Generated
    public void setServices(EndpointGroupServices services) {
        this.services = services;
    }

    @Generated
    public String toString() {
        return "EndpointGroup(name=" + this.getName() + ", type=" + this.getType() + ", loadBalancer=" + this.getLoadBalancer() + ", sharedConfiguration=" + this.getSharedConfiguration() + ", endpoints=" + this.getEndpoints() + ", services=" + this.getServices() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndpointGroup)) {
            return false;
        }
        EndpointGroup other = (EndpointGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        LoadBalancer this$loadBalancer = this.getLoadBalancer();
        LoadBalancer other$loadBalancer = other.getLoadBalancer();
        if (this$loadBalancer == null ? other$loadBalancer != null : !((Object)this$loadBalancer).equals(other$loadBalancer)) {
            return false;
        }
        String this$sharedConfiguration = this.getSharedConfiguration();
        String other$sharedConfiguration = other.getSharedConfiguration();
        if (this$sharedConfiguration == null ? other$sharedConfiguration != null : !this$sharedConfiguration.equals(other$sharedConfiguration)) {
            return false;
        }
        List<Endpoint> this$endpoints = this.getEndpoints();
        List<Endpoint> other$endpoints = other.getEndpoints();
        if (this$endpoints == null ? other$endpoints != null : !((Object)this$endpoints).equals(other$endpoints)) {
            return false;
        }
        EndpointGroupServices this$services = this.getServices();
        EndpointGroupServices other$services = other.getServices();
        return !(this$services == null ? other$services != null : !((Object)this$services).equals(other$services));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EndpointGroup;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        LoadBalancer $loadBalancer = this.getLoadBalancer();
        result = result * 59 + ($loadBalancer == null ? 43 : ((Object)$loadBalancer).hashCode());
        String $sharedConfiguration = this.getSharedConfiguration();
        result = result * 59 + ($sharedConfiguration == null ? 43 : $sharedConfiguration.hashCode());
        List<Endpoint> $endpoints = this.getEndpoints();
        result = result * 59 + ($endpoints == null ? 43 : ((Object)$endpoints).hashCode());
        EndpointGroupServices $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        return result;
    }

    @Generated
    public static class EndpointGroupBuilder {
        @Generated
        private String name;
        @Generated
        private String type;
        @Generated
        private boolean loadBalancer$set;
        @Generated
        private LoadBalancer loadBalancer$value;
        @Generated
        private String sharedConfiguration;
        @Generated
        private List<Endpoint> endpoints;
        @Generated
        private boolean services$set;
        @Generated
        private EndpointGroupServices services$value;

        @Generated
        EndpointGroupBuilder() {
        }

        @Generated
        public EndpointGroupBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(required=true)
        @Generated
        public EndpointGroupBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public EndpointGroupBuilder loadBalancer(LoadBalancer loadBalancer) {
            this.loadBalancer$value = loadBalancer;
            this.loadBalancer$set = true;
            return this;
        }

        @Generated
        public EndpointGroupBuilder sharedConfiguration(String sharedConfiguration) {
            this.sharedConfiguration = sharedConfiguration;
            return this;
        }

        @Generated
        public EndpointGroupBuilder endpoints(List<Endpoint> endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        @Generated
        public EndpointGroupBuilder services(EndpointGroupServices services) {
            this.services$value = services;
            this.services$set = true;
            return this;
        }

        @Generated
        public EndpointGroup build() {
            LoadBalancer loadBalancer$value = this.loadBalancer$value;
            if (!this.loadBalancer$set) {
                loadBalancer$value = EndpointGroup.$default$loadBalancer();
            }
            EndpointGroupServices services$value = this.services$value;
            if (!this.services$set) {
                services$value = EndpointGroup.$default$services();
            }
            return new EndpointGroup(this.name, this.type, loadBalancer$value, this.sharedConfiguration, this.endpoints, services$value);
        }

        @Generated
        public String toString() {
            return "EndpointGroup.EndpointGroupBuilder(name=" + this.name + ", type=" + this.type + ", loadBalancer$value=" + this.loadBalancer$value + ", sharedConfiguration=" + this.sharedConfiguration + ", endpoints=" + this.endpoints + ", services$value=" + this.services$value + ")";
        }
    }
}

