/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model.v4.endpointgroup;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.model.v4.endpointgroup.service.EndpointServices;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;

@Schema(name="EndpointV4")
public class Endpoint
implements Serializable {
    private static final long serialVersionUID = 7139083731513897591L;
    private static final int DEFAULT_WEIGHT = 1;
    @NotBlank
    private String name;
    @JsonProperty(required=true)
    @NotBlank
    private String type;
    private boolean secondary;
    private List<String> tenants;
    private int weight;
    private boolean inheritConfiguration;
    @Schema(implementation=Object.class)
    @JsonRawValue
    private String configuration;
    @Schema(implementation=Object.class)
    @JsonRawValue
    private String sharedConfigurationOverride;
    private EndpointServices services;

    @JsonSetter
    public void setConfiguration(JsonNode configuration) {
        if (configuration != null) {
            this.configuration = configuration.toString();
        }
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @JsonSetter
    public void setSharedConfigurationOverride(JsonNode overriddenSharedConfiguration) {
        if (overriddenSharedConfiguration != null) {
            this.sharedConfigurationOverride = overriddenSharedConfiguration.toString();
        }
    }

    public void setSharedConfigurationOverride(String overriddenSharedConfiguration) {
        this.sharedConfigurationOverride = overriddenSharedConfiguration;
    }

    @Generated
    private static int $default$weight() {
        return 1;
    }

    @Generated
    private static EndpointServices $default$services() {
        return new EndpointServices();
    }

    @Generated
    public static EndpointBuilder builder() {
        return new EndpointBuilder();
    }

    @Generated
    public Endpoint() {
        this.weight = Endpoint.$default$weight();
        this.services = Endpoint.$default$services();
    }

    @Generated
    public Endpoint(String name, String type, boolean secondary, List<String> tenants, int weight, boolean inheritConfiguration, String configuration, String sharedConfigurationOverride, EndpointServices services) {
        this.name = name;
        this.type = type;
        this.secondary = secondary;
        this.tenants = tenants;
        this.weight = weight;
        this.inheritConfiguration = inheritConfiguration;
        this.configuration = configuration;
        this.sharedConfigurationOverride = sharedConfigurationOverride;
        this.services = services;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public boolean isSecondary() {
        return this.secondary;
    }

    @Generated
    public List<String> getTenants() {
        return this.tenants;
    }

    @Generated
    public int getWeight() {
        return this.weight;
    }

    @Generated
    public boolean isInheritConfiguration() {
        return this.inheritConfiguration;
    }

    @Generated
    public String getConfiguration() {
        return this.configuration;
    }

    @Generated
    public String getSharedConfigurationOverride() {
        return this.sharedConfigurationOverride;
    }

    @Generated
    public EndpointServices getServices() {
        return this.services;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(required=true)
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setSecondary(boolean secondary) {
        this.secondary = secondary;
    }

    @Generated
    public void setTenants(List<String> tenants) {
        this.tenants = tenants;
    }

    @Generated
    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Generated
    public void setInheritConfiguration(boolean inheritConfiguration) {
        this.inheritConfiguration = inheritConfiguration;
    }

    @Generated
    public void setServices(EndpointServices services) {
        this.services = services;
    }

    @Generated
    public String toString() {
        return "Endpoint(name=" + this.getName() + ", type=" + this.getType() + ", secondary=" + this.isSecondary() + ", tenants=" + this.getTenants() + ", weight=" + this.getWeight() + ", inheritConfiguration=" + this.isInheritConfiguration() + ", configuration=" + this.getConfiguration() + ", sharedConfigurationOverride=" + this.getSharedConfigurationOverride() + ", services=" + this.getServices() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSecondary() != other.isSecondary()) {
            return false;
        }
        if (this.getWeight() != other.getWeight()) {
            return false;
        }
        if (this.isInheritConfiguration() != other.isInheritConfiguration()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<String> this$tenants = this.getTenants();
        List<String> other$tenants = other.getTenants();
        if (this$tenants == null ? other$tenants != null : !((Object)this$tenants).equals(other$tenants)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$sharedConfigurationOverride = this.getSharedConfigurationOverride();
        String other$sharedConfigurationOverride = other.getSharedConfigurationOverride();
        if (this$sharedConfigurationOverride == null ? other$sharedConfigurationOverride != null : !this$sharedConfigurationOverride.equals(other$sharedConfigurationOverride)) {
            return false;
        }
        EndpointServices this$services = this.getServices();
        EndpointServices other$services = other.getServices();
        return !(this$services == null ? other$services != null : !((Object)this$services).equals(other$services));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Endpoint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSecondary() ? 79 : 97);
        result = result * 59 + this.getWeight();
        result = result * 59 + (this.isInheritConfiguration() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<String> $tenants = this.getTenants();
        result = result * 59 + ($tenants == null ? 43 : ((Object)$tenants).hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $sharedConfigurationOverride = this.getSharedConfigurationOverride();
        result = result * 59 + ($sharedConfigurationOverride == null ? 43 : $sharedConfigurationOverride.hashCode());
        EndpointServices $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        return result;
    }

    @Generated
    public static class EndpointBuilder {
        @Generated
        private String name;
        @Generated
        private String type;
        @Generated
        private boolean secondary;
        @Generated
        private List<String> tenants;
        @Generated
        private boolean weight$set;
        @Generated
        private int weight$value;
        @Generated
        private boolean inheritConfiguration;
        @Generated
        private String configuration;
        @Generated
        private String sharedConfigurationOverride;
        @Generated
        private boolean services$set;
        @Generated
        private EndpointServices services$value;

        @Generated
        EndpointBuilder() {
        }

        @Generated
        public EndpointBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(required=true)
        @Generated
        public EndpointBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public EndpointBuilder secondary(boolean secondary) {
            this.secondary = secondary;
            return this;
        }

        @Generated
        public EndpointBuilder tenants(List<String> tenants) {
            this.tenants = tenants;
            return this;
        }

        @Generated
        public EndpointBuilder weight(int weight) {
            this.weight$value = weight;
            this.weight$set = true;
            return this;
        }

        @Generated
        public EndpointBuilder inheritConfiguration(boolean inheritConfiguration) {
            this.inheritConfiguration = inheritConfiguration;
            return this;
        }

        @Generated
        public EndpointBuilder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public EndpointBuilder sharedConfigurationOverride(String sharedConfigurationOverride) {
            this.sharedConfigurationOverride = sharedConfigurationOverride;
            return this;
        }

        @Generated
        public EndpointBuilder services(EndpointServices services) {
            this.services$value = services;
            this.services$set = true;
            return this;
        }

        @Generated
        public Endpoint build() {
            int weight$value = this.weight$value;
            if (!this.weight$set) {
                weight$value = Endpoint.$default$weight();
            }
            EndpointServices services$value = this.services$value;
            if (!this.services$set) {
                services$value = Endpoint.$default$services();
            }
            return new Endpoint(this.name, this.type, this.secondary, this.tenants, weight$value, this.inheritConfiguration, this.configuration, this.sharedConfigurationOverride, services$value);
        }

        @Generated
        public String toString() {
            return "Endpoint.EndpointBuilder(name=" + this.name + ", type=" + this.type + ", secondary=" + this.secondary + ", tenants=" + this.tenants + ", weight$value=" + this.weight$value + ", inheritConfiguration=" + this.inheritConfiguration + ", configuration=" + this.configuration + ", sharedConfigurationOverride=" + this.sharedConfigurationOverride + ", services$value=" + this.services$value + ")";
        }
    }
}

