/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model.v4.analytics.sampling;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import io.gravitee.common.utils.DurationParser;
import java.time.Duration;
import java.util.Map;
import java.util.function.BiFunction;
import lombok.Generated;

public enum SamplingType {
    PROBABILITY("probability", (value, validationLimit) -> {
        try {
            double parseDouble = Double.parseDouble(value);
            return parseDouble >= 0.01 && parseDouble <= ((ValidationLimit.ProbabilityLimit)validationLimit).getLimit();
        }
        catch (Exception e) {
            return false;
        }
    }),
    TEMPORAL("temporal", (value, validationLimit) -> {
        try {
            Duration duration = DurationParser.parse((String)value);
            Duration minDuration = Duration.parse(((ValidationLimit.TemporalLimit)validationLimit).getLimit());
            return duration != null && duration.compareTo(minDuration) >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }),
    COUNT("count", (value, validationLimit) -> {
        try {
            int count = Integer.parseInt(value);
            return count >= ((ValidationLimit.CountLimit)validationLimit).getLimit();
        }
        catch (Exception e) {
            return false;
        }
    });

    private static final Map<String, SamplingType> LABELS_MAP;
    @JsonValue
    private final String label;
    @JsonIgnore
    private final BiFunction<String, ValidationLimit<?>, Boolean> validationFunction;

    public String getLabel() {
        return this.label;
    }

    public boolean validate(String value, ValidationLimit validationLimit) {
        return this.validationFunction.apply(value, validationLimit);
    }

    public static SamplingType fromLabel(String label) {
        if (label != null) {
            return LABELS_MAP.get(label);
        }
        return null;
    }

    @Generated
    private SamplingType(String label, BiFunction<String, ValidationLimit<?>, Boolean> validationFunction) {
        this.label = label;
        this.validationFunction = validationFunction;
    }

    static {
        LABELS_MAP = Map.of(SamplingType.PROBABILITY.label, PROBABILITY, SamplingType.TEMPORAL.label, TEMPORAL, SamplingType.COUNT.label, COUNT);
    }

    public static abstract class ValidationLimit<T> {
        abstract T getLimit();

        public static class TemporalLimit
        extends ValidationLimit<String> {
            private String temporal;

            @Override
            String getLimit() {
                return this.temporal;
            }

            @Generated
            public TemporalLimit(String temporal) {
                this.temporal = temporal;
            }
        }

        public static class ProbabilityLimit
        extends ValidationLimit<Double> {
            private double probability;

            @Override
            Double getLimit() {
                return this.probability;
            }

            @Generated
            public ProbabilityLimit(double probability) {
                this.probability = probability;
            }
        }

        public static class CountLimit
        extends ValidationLimit<Integer> {
            private int count;

            @Override
            Integer getLimit() {
                return this.count;
            }

            @Generated
            public CountLimit(int count) {
                this.count = count;
            }
        }
    }
}

