/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model.v4;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.analytics.Analytics;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.execution.FlowExecution;
import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.definition.model.v4.plan.Plan;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.definition.model.v4.resource.Resource;
import io.gravitee.definition.model.v4.service.ApiServices;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public class Api
implements Serializable {
    @JsonProperty(required=true)
    @NotBlank
    private String id;
    @JsonProperty(required=true)
    @NotBlank
    private String name;
    @JsonProperty(required=true)
    @NotBlank
    private ApiType type;
    @JsonProperty(required=true)
    @NotBlank
    private String apiVersion;
    @JsonProperty(required=true)
    @NotNull
    private DefinitionVersion definitionVersion;
    private Set<@NotBlank String> tags;
    @JsonProperty(required=true)
    private @NotEmpty List<@NotNull Listener> listeners;
    @JsonProperty(required=true)
    @NotEmpty
    private List<EndpointGroup> endpointGroups;
    private Analytics analytics;
    private List<Property> properties;
    private List<Resource> resources;
    @JsonProperty(required=true)
    @NotNull
    private @NotNull Map<@NotEmpty String, @NotNull Plan> plans;
    private FlowExecution flowExecution = new FlowExecution();
    private List<Flow> flows;
    private Map<String, Map<String, ResponseTemplate>> responseTemplates;
    private ApiServices services;

    public Plan getPlan(String plan) {
        return this.plans.get(plan);
    }

    public List<Plan> getPlans() {
        if (this.plans != null) {
            return new ArrayList<Plan>(this.plans.values());
        }
        return null;
    }

    public void setPlans(List<Plan> plans) {
        this.plans = plans != null ? plans.stream().collect(Collectors.toMap(Plan::getId, Function.identity())) : new HashMap<String, Plan>();
    }

    @Generated
    private static DefinitionVersion $default$definitionVersion() {
        return DefinitionVersion.V4;
    }

    @Generated
    public static ApiBuilder builder() {
        return new ApiBuilder();
    }

    @Generated
    public ApiBuilder toBuilder() {
        return new ApiBuilder().id(this.id).name(this.name).type(this.type).apiVersion(this.apiVersion).definitionVersion(this.definitionVersion).tags(this.tags).listeners(this.listeners).endpointGroups(this.endpointGroups).analytics(this.analytics).properties(this.properties).resources(this.resources).plans(this.plans).flowExecution(this.flowExecution).flows(this.flows).responseTemplates(this.responseTemplates).services(this.services);
    }

    @Generated
    public Api() {
        this.definitionVersion = Api.$default$definitionVersion();
    }

    @Generated
    public Api(String id, String name, ApiType type, String apiVersion, DefinitionVersion definitionVersion, Set<@NotBlank String> tags, List<@NotNull Listener> listeners, List<EndpointGroup> endpointGroups, Analytics analytics, List<Property> properties, List<Resource> resources, Map<@NotEmpty String, @NotNull Plan> plans, FlowExecution flowExecution, List<Flow> flows, Map<String, Map<String, ResponseTemplate>> responseTemplates, ApiServices services) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.apiVersion = apiVersion;
        this.definitionVersion = definitionVersion;
        this.tags = tags;
        this.listeners = listeners;
        this.endpointGroups = endpointGroups;
        this.analytics = analytics;
        this.properties = properties;
        this.resources = resources;
        this.plans = plans;
        this.flowExecution = flowExecution;
        this.flows = flows;
        this.responseTemplates = responseTemplates;
        this.services = services;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ApiType getType() {
        return this.type;
    }

    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Generated
    public DefinitionVersion getDefinitionVersion() {
        return this.definitionVersion;
    }

    @Generated
    public Set<@NotBlank String> getTags() {
        return this.tags;
    }

    @Generated
    public List<@NotNull Listener> getListeners() {
        return this.listeners;
    }

    @Generated
    public List<EndpointGroup> getEndpointGroups() {
        return this.endpointGroups;
    }

    @Generated
    public Analytics getAnalytics() {
        return this.analytics;
    }

    @Generated
    public List<Property> getProperties() {
        return this.properties;
    }

    @Generated
    public List<Resource> getResources() {
        return this.resources;
    }

    @Generated
    public FlowExecution getFlowExecution() {
        return this.flowExecution;
    }

    @Generated
    public List<Flow> getFlows() {
        return this.flows;
    }

    @Generated
    public Map<String, Map<String, ResponseTemplate>> getResponseTemplates() {
        return this.responseTemplates;
    }

    @Generated
    public ApiServices getServices() {
        return this.services;
    }

    @JsonProperty(required=true)
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(required=true)
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(required=true)
    @Generated
    public void setType(ApiType type) {
        this.type = type;
    }

    @JsonProperty(required=true)
    @Generated
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(required=true)
    @Generated
    public void setDefinitionVersion(DefinitionVersion definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    @Generated
    public void setTags(Set<@NotBlank String> tags) {
        this.tags = tags;
    }

    @JsonProperty(required=true)
    @Generated
    public void setListeners(List<@NotNull Listener> listeners) {
        this.listeners = listeners;
    }

    @JsonProperty(required=true)
    @Generated
    public void setEndpointGroups(List<EndpointGroup> endpointGroups) {
        this.endpointGroups = endpointGroups;
    }

    @Generated
    public void setAnalytics(Analytics analytics) {
        this.analytics = analytics;
    }

    @Generated
    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    @Generated
    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    @Generated
    public void setFlowExecution(FlowExecution flowExecution) {
        this.flowExecution = flowExecution;
    }

    @Generated
    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    @Generated
    public void setResponseTemplates(Map<String, Map<String, ResponseTemplate>> responseTemplates) {
        this.responseTemplates = responseTemplates;
    }

    @Generated
    public void setServices(ApiServices services) {
        this.services = services;
    }

    @Generated
    public String toString() {
        return "Api(id=" + this.getId() + ", name=" + this.getName() + ", type=" + this.getType() + ", apiVersion=" + this.getApiVersion() + ", definitionVersion=" + this.getDefinitionVersion() + ", tags=" + this.getTags() + ", listeners=" + this.getListeners() + ", endpointGroups=" + this.getEndpointGroups() + ", analytics=" + this.getAnalytics() + ", properties=" + this.getProperties() + ", resources=" + this.getResources() + ", plans=" + this.getPlans() + ", flowExecution=" + this.getFlowExecution() + ", flows=" + this.getFlows() + ", responseTemplates=" + this.getResponseTemplates() + ", services=" + this.getServices() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Api)) {
            return false;
        }
        Api other = (Api)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ApiType this$type = this.getType();
        ApiType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        DefinitionVersion this$definitionVersion = this.getDefinitionVersion();
        DefinitionVersion other$definitionVersion = other.getDefinitionVersion();
        if (this$definitionVersion == null ? other$definitionVersion != null : !((Object)((Object)this$definitionVersion)).equals((Object)other$definitionVersion)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<Listener> this$listeners = this.getListeners();
        List<Listener> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        List<EndpointGroup> this$endpointGroups = this.getEndpointGroups();
        List<EndpointGroup> other$endpointGroups = other.getEndpointGroups();
        if (this$endpointGroups == null ? other$endpointGroups != null : !((Object)this$endpointGroups).equals(other$endpointGroups)) {
            return false;
        }
        Analytics this$analytics = this.getAnalytics();
        Analytics other$analytics = other.getAnalytics();
        if (this$analytics == null ? other$analytics != null : !((Object)this$analytics).equals(other$analytics)) {
            return false;
        }
        List<Property> this$properties = this.getProperties();
        List<Property> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<Resource> this$resources = this.getResources();
        List<Resource> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        List<Plan> this$plans = this.getPlans();
        List<Plan> other$plans = other.getPlans();
        if (this$plans == null ? other$plans != null : !((Object)this$plans).equals(other$plans)) {
            return false;
        }
        FlowExecution this$flowExecution = this.getFlowExecution();
        FlowExecution other$flowExecution = other.getFlowExecution();
        if (this$flowExecution == null ? other$flowExecution != null : !((Object)this$flowExecution).equals(other$flowExecution)) {
            return false;
        }
        List<Flow> this$flows = this.getFlows();
        List<Flow> other$flows = other.getFlows();
        if (this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows)) {
            return false;
        }
        Map<String, Map<String, ResponseTemplate>> this$responseTemplates = this.getResponseTemplates();
        Map<String, Map<String, ResponseTemplate>> other$responseTemplates = other.getResponseTemplates();
        if (this$responseTemplates == null ? other$responseTemplates != null : !((Object)this$responseTemplates).equals(other$responseTemplates)) {
            return false;
        }
        ApiServices this$services = this.getServices();
        ApiServices other$services = other.getServices();
        return !(this$services == null ? other$services != null : !((Object)this$services).equals(other$services));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Api;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ApiType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        DefinitionVersion $definitionVersion = this.getDefinitionVersion();
        result = result * 59 + ($definitionVersion == null ? 43 : ((Object)((Object)$definitionVersion)).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<Listener> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        List<EndpointGroup> $endpointGroups = this.getEndpointGroups();
        result = result * 59 + ($endpointGroups == null ? 43 : ((Object)$endpointGroups).hashCode());
        Analytics $analytics = this.getAnalytics();
        result = result * 59 + ($analytics == null ? 43 : ((Object)$analytics).hashCode());
        List<Property> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<Resource> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        List<Plan> $plans = this.getPlans();
        result = result * 59 + ($plans == null ? 43 : ((Object)$plans).hashCode());
        FlowExecution $flowExecution = this.getFlowExecution();
        result = result * 59 + ($flowExecution == null ? 43 : ((Object)$flowExecution).hashCode());
        List<Flow> $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        Map<String, Map<String, ResponseTemplate>> $responseTemplates = this.getResponseTemplates();
        result = result * 59 + ($responseTemplates == null ? 43 : ((Object)$responseTemplates).hashCode());
        ApiServices $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        return result;
    }

    public static class ApiBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private ApiType type;
        @Generated
        private String apiVersion;
        @Generated
        private boolean definitionVersion$set;
        @Generated
        private DefinitionVersion definitionVersion$value;
        @Generated
        private Set<@NotBlank String> tags;
        @Generated
        private List<@NotNull Listener> listeners;
        @Generated
        private List<EndpointGroup> endpointGroups;
        @Generated
        private Analytics analytics;
        @Generated
        private List<Property> properties;
        @Generated
        private List<Resource> resources;
        @Generated
        private Map<@NotEmpty String, @NotNull Plan> plans;
        @Generated
        private FlowExecution flowExecution;
        @Generated
        private List<Flow> flows;
        @Generated
        private Map<String, Map<String, ResponseTemplate>> responseTemplates;
        @Generated
        private ApiServices services;

        public ApiBuilder withProperties(Map<String, String> properties) {
            if (properties != null) {
                this.properties = properties.entrySet().stream().map(p -> new Property((String)p.getKey(), (String)p.getValue(), false, false)).collect(Collectors.toList());
            }
            return this;
        }

        @Generated
        ApiBuilder() {
        }

        @JsonProperty(required=true)
        @Generated
        public ApiBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(required=true)
        @Generated
        public ApiBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(required=true)
        @Generated
        public ApiBuilder type(ApiType type) {
            this.type = type;
            return this;
        }

        @JsonProperty(required=true)
        @Generated
        public ApiBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @JsonProperty(required=true)
        @Generated
        public ApiBuilder definitionVersion(DefinitionVersion definitionVersion) {
            this.definitionVersion$value = definitionVersion;
            this.definitionVersion$set = true;
            return this;
        }

        @Generated
        public ApiBuilder tags(Set<@NotBlank String> tags) {
            this.tags = tags;
            return this;
        }

        @JsonProperty(required=true)
        @Generated
        public ApiBuilder listeners(List<@NotNull Listener> listeners) {
            this.listeners = listeners;
            return this;
        }

        @JsonProperty(required=true)
        @Generated
        public ApiBuilder endpointGroups(List<EndpointGroup> endpointGroups) {
            this.endpointGroups = endpointGroups;
            return this;
        }

        @Generated
        public ApiBuilder analytics(Analytics analytics) {
            this.analytics = analytics;
            return this;
        }

        @Generated
        public ApiBuilder properties(List<Property> properties) {
            this.properties = properties;
            return this;
        }

        @Generated
        public ApiBuilder resources(List<Resource> resources) {
            this.resources = resources;
            return this;
        }

        @JsonProperty(required=true)
        @Generated
        public ApiBuilder plans(Map<@NotEmpty String, @NotNull Plan> plans) {
            this.plans = plans;
            return this;
        }

        @Generated
        public ApiBuilder flowExecution(FlowExecution flowExecution) {
            this.flowExecution = flowExecution;
            return this;
        }

        @Generated
        public ApiBuilder flows(List<Flow> flows) {
            this.flows = flows;
            return this;
        }

        @Generated
        public ApiBuilder responseTemplates(Map<String, Map<String, ResponseTemplate>> responseTemplates) {
            this.responseTemplates = responseTemplates;
            return this;
        }

        @Generated
        public ApiBuilder services(ApiServices services) {
            this.services = services;
            return this;
        }

        @Generated
        public Api build() {
            DefinitionVersion definitionVersion$value = this.definitionVersion$value;
            if (!this.definitionVersion$set) {
                definitionVersion$value = Api.$default$definitionVersion();
            }
            return new Api(this.id, this.name, this.type, this.apiVersion, definitionVersion$value, this.tags, this.listeners, this.endpointGroups, this.analytics, this.properties, this.resources, this.plans, this.flowExecution, this.flows, this.responseTemplates, this.services);
        }

        @Generated
        public String toString() {
            return "Api.ApiBuilder(id=" + this.id + ", name=" + this.name + ", type=" + this.type + ", apiVersion=" + this.apiVersion + ", definitionVersion$value=" + this.definitionVersion$value + ", tags=" + this.tags + ", listeners=" + this.listeners + ", endpointGroups=" + this.endpointGroups + ", analytics=" + this.analytics + ", properties=" + this.properties + ", resources=" + this.resources + ", plans=" + this.plans + ", flowExecution=" + this.flowExecution + ", flows=" + this.flows + ", responseTemplates=" + this.responseTemplates + ", services=" + this.services + ")";
        }
    }
}

