/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.Service;
import io.gravitee.definition.model.services.discovery.EndpointDiscoveryService;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyService;
import io.gravitee.definition.model.services.healthcheck.HealthCheckService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class Services
implements Serializable {
    @JsonIgnore
    private final Map<Class<? extends Service>, Service> services = new HashMap<Class<? extends Service>, Service>();

    @JsonIgnore
    public Collection<Service> getAll() {
        return this.services.values();
    }

    @JsonIgnore
    public <T extends Service> T get(Class<T> serviceType) {
        return (T)this.services.get(serviceType);
    }

    @JsonIgnore
    public void set(Collection<? extends Service> services) {
        services.forEach(service -> this.services.put((Class<? extends Service>)service.getClass(), (Service)service));
    }

    @JsonIgnore
    public void put(Class<? extends Service> clazz, Service service) {
        this.services.put(clazz, service);
    }

    @JsonIgnore
    public void remove(Class<? extends Service> clazz) {
        this.services.remove(clazz);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.services.isEmpty();
    }

    @JsonProperty(value="discovery")
    public EndpointDiscoveryService getDiscoveryService() {
        return this.get(EndpointDiscoveryService.class);
    }

    public void setDiscoveryService(EndpointDiscoveryService discoveryService) {
        if (discoveryService != null) {
            this.put(EndpointDiscoveryService.class, discoveryService);
        }
    }

    @JsonProperty(value="health-check")
    public HealthCheckService getHealthCheckService() {
        return this.get(HealthCheckService.class);
    }

    public void setHealthCheckService(HealthCheckService healthCheckService) {
        if (healthCheckService != null) {
            this.put(HealthCheckService.class, healthCheckService);
        }
    }

    @JsonProperty(value="dynamic-property")
    public DynamicPropertyService getDynamicPropertyService() {
        return this.get(DynamicPropertyService.class);
    }

    public void setDynamicPropertyService(DynamicPropertyService dynamicPropertyService) {
        if (dynamicPropertyService != null) {
            this.put(DynamicPropertyService.class, dynamicPropertyService);
        }
    }
}

