/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model.plugins.resources;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;

public class Resource
implements Serializable {
    private boolean enabled = true;
    private String name;
    private String type;
    private Object configuration;

    public Resource() {
    }

    @JsonCreator
    public Resource(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type", required=true) String type, @JsonProperty(value="configuration", required=true) JsonNode configuration) {
        this.name = name;
        this.type = type;
        this.configuration = configuration;
    }

    @Schema(implementation=Object.class)
    @JsonRawValue
    public String getConfiguration() {
        return this.configuration == null ? null : this.configuration.toString();
    }

    @JsonIgnore
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @JsonSetter
    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return Objects.equals(this.name, resource.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Generated
    public static ResourceBuilder builder() {
        return new ResourceBuilder();
    }

    @Generated
    public Resource(boolean enabled, String name, String type, Object configuration) {
        this.enabled = enabled;
        this.name = name;
        this.type = type;
        this.configuration = configuration;
    }

    @Generated
    public static class ResourceBuilder {
        @Generated
        private boolean enabled;
        @Generated
        private String name;
        @Generated
        private String type;
        @Generated
        private Object configuration;

        @Generated
        ResourceBuilder() {
        }

        @Generated
        public ResourceBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public ResourceBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ResourceBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public ResourceBuilder configuration(Object configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public Resource build() {
            return new Resource(this.enabled, this.name, this.type, this.configuration);
        }

        @Generated
        public String toString() {
            return "Resource.ResourceBuilder(enabled=" + this.enabled + ", name=" + this.name + ", type=" + this.type + ", configuration=" + this.configuration + ")";
        }
    }
}

