/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model.kubernetes.v1alpha1;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.kubernetes.mapper.CustomResource;
import io.gravitee.kubernetes.mapper.GroupVersionKind;
import io.gravitee.kubernetes.mapper.ObjectMeta;
import java.util.List;

public class ApiDefinitionResource
extends CustomResource<ObjectNode> {
    private static final List<String> UNSUPPORTED_API_FIELDS = List.of("definition_context", "execution_mode", "primaryOwner", "groups", "members", "createdAt", "updatedAt", "picture", "apiMedia");
    private static final List<String> UNSUPPORTED_PLAN_FIELDS = List.of("created_at", "updated_at", "published_at");
    private static final List<String> UNSUPPORTED_PAGE_FIELDS = List.of("lastContributor", "lastModificationDate", "parentPath", "excludedAccessControls", "accessControls", "attached_media", "contentType");
    private static final String PLANS_FIELD = "plans";
    private static final String PAGES_FIELD = "pages";
    private static final String NAME_FIELD = "name";
    private static final String METADATA_FIELD = "metadata";
    private static final List<String> UNSUPPORTED_METADATA_FIELDS = List.of("apiId");
    private static final List<String> API_ID_FIELDS = List.of("crossId", "id");
    private static final List<String> PLAN_ID_FIELDS = List.of("crossId", "id", "api");
    private static final String VERSION_FIELD = "version";
    private static final String CONTEXT_REF_FIELD = "contextRef";
    private static final String CONTEXT_NAME_FIELD = "name";
    private static final String CONTEXT_NAMESPACE_FIELD = "namespace";
    private static final String PROXY_FIELD = "proxy";
    private static final String VIRTUAL_HOSTS_FIELD = "virtual_hosts";
    private static final String VIRTUAL_HOST_PATH_FIELD = "path";

    public ApiDefinitionResource(String name, ObjectNode apiDefinition) {
        super(GroupVersionKind.GIO_V1_ALPHA_1_API_DEFINITION, new ObjectMeta(name), (Object)apiDefinition);
        this.removeUnsupportedFields();
    }

    public void setContextPath(String contextPath) {
        ObjectNode proxy = (ObjectNode)((ObjectNode)this.getSpec()).get(PROXY_FIELD).deepCopy();
        ArrayNode virtualHosts = (ArrayNode)proxy.get(VIRTUAL_HOSTS_FIELD);
        ObjectNode virtualHost = ((ObjectNode)virtualHosts.iterator().next()).put(VIRTUAL_HOST_PATH_FIELD, contextPath);
        virtualHost.put(VIRTUAL_HOST_PATH_FIELD, contextPath);
        ((ObjectNode)this.getSpec()).set(PROXY_FIELD, (JsonNode)proxy);
    }

    public void setVersion(String version) {
        ((ObjectNode)this.getSpec()).put(VERSION_FIELD, version);
    }

    public void setContextRef(String name, String namespace) {
        ((ObjectNode)this.getSpec()).putObject(CONTEXT_REF_FIELD).put("name", name).put(CONTEXT_NAMESPACE_FIELD, namespace);
    }

    public void removeIds() {
        ObjectNode spec = (ObjectNode)this.getSpec();
        spec.remove(API_ID_FIELDS);
        if (spec.hasNonNull(PLANS_FIELD)) {
            spec.get(PLANS_FIELD).forEach(plan -> ((ObjectNode)plan).remove(PLAN_ID_FIELDS));
        }
    }

    private void removeUnsupportedFields() {
        ObjectNode spec = (ObjectNode)this.getSpec();
        spec.remove(UNSUPPORTED_API_FIELDS);
        if (spec.hasNonNull(PLANS_FIELD)) {
            spec.get(PLANS_FIELD).forEach(plan -> ((ObjectNode)plan).remove(UNSUPPORTED_PLAN_FIELDS));
        }
        if (spec.hasNonNull(PAGES_FIELD)) {
            spec.replace(PAGES_FIELD, this.mapPages((ArrayNode)spec.get(PAGES_FIELD)));
        }
        if (spec.hasNonNull(METADATA_FIELD)) {
            spec.get(METADATA_FIELD).forEach(meta -> ((ObjectNode)meta).remove(UNSUPPORTED_METADATA_FIELDS));
        }
    }

    private JsonNode mapPages(ArrayNode pages) {
        ObjectNode pagesMap = JsonNodeFactory.instance.objectNode();
        for (JsonNode page : pages) {
            pagesMap.set(page.get("name").asText(), (JsonNode)((ObjectNode)page).remove(UNSUPPORTED_PAGE_FIELDS));
        }
        return pagesMap;
    }
}

