/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;

@Schema(enumAsRef=true, type="string", allowableValues={"v3", "v4-emulation-engine"})
public enum ExecutionMode {
    V3("v3"),
    V4_EMULATION_ENGINE("v4-emulation-engine");

    private static final Map<String, ExecutionMode> BY_LABEL;
    @JsonValue
    private final String label;

    private ExecutionMode(String label) {
        this.label = label;
    }

    @JsonCreator
    public static ExecutionMode fromLabel(String label) {
        if (label != null) {
            if (label.equals("jupiter")) {
                return V4_EMULATION_ENGINE;
            }
            return BY_LABEL.getOrDefault(label, V3);
        }
        return V3;
    }

    public String getLabel() {
        return this.label;
    }

    static {
        BY_LABEL = Map.of(ExecutionMode.V3.label, V3, ExecutionMode.V4_EMULATION_ENGINE.label, V4_EMULATION_ENGINE);
    }
}

