/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.endpoint.EndpointStatusListener;
import io.gravitee.definition.model.services.healthcheck.EndpointHealthCheckService;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public class Endpoint
implements Serializable {
    private static final String DEFAULT_TYPE = "http";
    private final Set<EndpointStatusListener> listeners = new HashSet<EndpointStatusListener>();
    public static final int DEFAULT_WEIGHT = 1;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="target")
    private String target;
    @JsonProperty(value="weight")
    private int weight;
    @JsonProperty(value="backup")
    private boolean backup;
    @JsonIgnore
    private Status status;
    @JsonProperty(value="tenants")
    private List<String> tenants;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="inherit")
    private Boolean inherit;
    @JsonProperty(value="healthcheck")
    private EndpointHealthCheckService healthCheck;
    @JsonIgnore
    private transient String configuration;

    public Endpoint(String type, String name, String target) {
        this.type = type != null ? type : DEFAULT_TYPE;
        this.name = name;
        this.target = target;
        this.status = Status.UP;
        this.weight = 1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void updateStatus(Status status) {
        this.status = status;
        this.listeners.forEach(endpointStatusListener -> endpointStatusListener.onStatusChanged(status));
    }

    public List<String> getTenants() {
        return this.tenants;
    }

    public void setTenants(List<String> tenants) {
        this.tenants = tenants;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getInherit() {
        return this.inherit;
    }

    public void setInherit(Boolean inherit) {
        this.inherit = inherit;
    }

    public void addEndpointStatusListener(EndpointStatusListener listener) {
        this.listeners.add(listener);
    }

    @JsonIgnore
    public String getConfiguration() {
        return this.configuration;
    }

    @JsonIgnore
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public EndpointHealthCheckService getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(EndpointHealthCheckService healthCheck) {
        this.healthCheck = healthCheck;
    }

    @JsonIgnore
    public Set<EndpointStatusListener> getEndpointStatusListeners() {
        return this.listeners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return this.name.equals(endpoint.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Generated
    private static int $default$weight() {
        return 1;
    }

    @Generated
    private static Status $default$status() {
        return Status.UP;
    }

    @Generated
    private static String $default$type() {
        return DEFAULT_TYPE;
    }

    @Generated
    protected Endpoint(EndpointBuilder<?, ?> b) {
        this.name = b.name;
        this.target = b.target;
        this.weight = b.weight$set ? b.weight$value : Endpoint.$default$weight();
        this.backup = b.backup;
        this.status = b.status$set ? b.status$value : Endpoint.$default$status();
        this.tenants = b.tenants;
        this.type = b.type$set ? b.type$value : Endpoint.$default$type();
        this.inherit = b.inherit;
        this.healthCheck = b.healthCheck;
        this.configuration = b.configuration;
    }

    @Generated
    public static EndpointBuilder<?, ?> builder() {
        return new EndpointBuilderImpl();
    }

    @Generated
    public Endpoint(String name, String target, int weight, boolean backup, Status status, List<String> tenants, String type, Boolean inherit, EndpointHealthCheckService healthCheck, String configuration) {
        this.name = name;
        this.target = target;
        this.weight = weight;
        this.backup = backup;
        this.status = status;
        this.tenants = tenants;
        this.type = type;
        this.inherit = inherit;
        this.healthCheck = healthCheck;
        this.configuration = configuration;
    }

    @Generated
    public Endpoint() {
        this.weight = Endpoint.$default$weight();
        this.status = Endpoint.$default$status();
        this.type = Endpoint.$default$type();
    }

    public static enum Status {
        UP(3),
        DOWN(0),
        TRANSITIONALLY_DOWN(1),
        TRANSITIONALLY_UP(2);

        private final int code;

        private Status(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public boolean isDown() {
            return this == DOWN || this == TRANSITIONALLY_UP;
        }
    }

    @Generated
    public static abstract class EndpointBuilder<C extends Endpoint, B extends EndpointBuilder<C, B>> {
        @Generated
        private String name;
        @Generated
        private String target;
        @Generated
        private boolean weight$set;
        @Generated
        private int weight$value;
        @Generated
        private boolean backup;
        @Generated
        private boolean status$set;
        @Generated
        private Status status$value;
        @Generated
        private List<String> tenants;
        @Generated
        private boolean type$set;
        @Generated
        private String type$value;
        @Generated
        private Boolean inherit;
        @Generated
        private EndpointHealthCheckService healthCheck;
        @Generated
        private String configuration;

        @JsonProperty(value="name")
        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @JsonProperty(value="target")
        @Generated
        public B target(String target) {
            this.target = target;
            return this.self();
        }

        @JsonProperty(value="weight")
        @Generated
        public B weight(int weight) {
            this.weight$value = weight;
            this.weight$set = true;
            return this.self();
        }

        @JsonProperty(value="backup")
        @Generated
        public B backup(boolean backup) {
            this.backup = backup;
            return this.self();
        }

        @JsonIgnore
        @Generated
        public B status(Status status) {
            this.status$value = status;
            this.status$set = true;
            return this.self();
        }

        @JsonProperty(value="tenants")
        @Generated
        public B tenants(List<String> tenants) {
            this.tenants = tenants;
            return this.self();
        }

        @JsonProperty(value="type")
        @Generated
        public B type(String type) {
            this.type$value = type;
            this.type$set = true;
            return this.self();
        }

        @JsonProperty(value="inherit")
        @Generated
        public B inherit(Boolean inherit) {
            this.inherit = inherit;
            return this.self();
        }

        @JsonProperty(value="healthcheck")
        @Generated
        public B healthCheck(EndpointHealthCheckService healthCheck) {
            this.healthCheck = healthCheck;
            return this.self();
        }

        @JsonIgnore
        @Generated
        public B configuration(String configuration) {
            this.configuration = configuration;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Endpoint.EndpointBuilder(name=" + this.name + ", target=" + this.target + ", weight$value=" + this.weight$value + ", backup=" + this.backup + ", status$value=" + this.status$value + ", tenants=" + this.tenants + ", type$value=" + this.type$value + ", inherit=" + this.inherit + ", healthCheck=" + this.healthCheck + ", configuration=" + this.configuration + ")";
        }
    }

    @Generated
    private static final class EndpointBuilderImpl
    extends EndpointBuilder<Endpoint, EndpointBuilderImpl> {
        @Generated
        private EndpointBuilderImpl() {
        }

        @Override
        @Generated
        protected EndpointBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Endpoint build() {
            return new Endpoint(this);
        }
    }
}

