/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public enum DefinitionVersion {
    V1("1.0.0"),
    V2("2.0.0"),
    V4("4.0.0");

    private static final Map<String, DefinitionVersion> BY_LABEL;
    private final String label;

    @JsonCreator
    public static DefinitionVersion valueOfLabel(String label) {
        return BY_LABEL.get(label);
    }

    public static Set<String> versions() {
        return BY_LABEL.keySet();
    }

    public Integer asInteger() {
        return Integer.valueOf(this.label.replaceAll("\\.", ""));
    }

    @JsonValue
    public String getLabel() {
        return this.label;
    }

    @Generated
    private DefinitionVersion(String label) {
        this.label = label;
    }

    static {
        BY_LABEL = new HashMap<String, DefinitionVersion>();
        for (DefinitionVersion e : DefinitionVersion.values()) {
            BY_LABEL.put(e.label, e);
        }
    }
}

