/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model;

import java.io.Serializable;
import lombok.Generated;

public class DefinitionContext
implements Serializable {
    private static final long serialVersionUID = -8942499479175567992L;
    public static final String ORIGIN_KUBERNETES = "kubernetes";
    public static final String ORIGIN_MANAGEMENT = "management";
    public static final String MODE_FULLY_MANAGED = "fully_managed";
    public static final String MODE_API_DEFINITION_ONLY = "api_definition_only";
    private String origin;
    private String mode;
    private String syncFrom;

    public DefinitionContext() {
        this(ORIGIN_MANAGEMENT, MODE_FULLY_MANAGED, ORIGIN_MANAGEMENT);
    }

    public DefinitionContext(String origin, String mode, String syncFrom) {
        this.origin = origin != null ? origin : ORIGIN_MANAGEMENT;
        this.mode = mode != null ? mode : MODE_FULLY_MANAGED;
        this.syncFrom = syncFrom == null ? ORIGIN_MANAGEMENT : syncFrom;
    }

    public DefinitionContext(String origin, String mode) {
        this(origin, mode, null);
    }

    public boolean isOriginManagement() {
        return DefinitionContext.isManagement(this.origin);
    }

    public boolean isOriginKubernetes() {
        return DefinitionContext.isKubernetes(this.origin);
    }

    public boolean isSyncFromKubernetes() {
        return DefinitionContext.isKubernetes(this.syncFrom);
    }

    public boolean isSyncFromManagement() {
        return DefinitionContext.isManagement(this.syncFrom);
    }

    public static boolean isManagement(String value) {
        return ORIGIN_MANAGEMENT.equalsIgnoreCase(value);
    }

    public static boolean isKubernetes(String value) {
        return ORIGIN_KUBERNETES.equalsIgnoreCase(value);
    }

    @Generated
    public static DefinitionContextBuilder builder() {
        return new DefinitionContextBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefinitionContext)) {
            return false;
        }
        DefinitionContext other = (DefinitionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        String this$syncFrom = this.getSyncFrom();
        String other$syncFrom = other.getSyncFrom();
        return !(this$syncFrom == null ? other$syncFrom != null : !this$syncFrom.equals(other$syncFrom));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefinitionContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        String $syncFrom = this.getSyncFrom();
        result = result * 59 + ($syncFrom == null ? 43 : $syncFrom.hashCode());
        return result;
    }

    @Generated
    public String getOrigin() {
        return this.origin;
    }

    @Generated
    public String getMode() {
        return this.mode;
    }

    @Generated
    public String getSyncFrom() {
        return this.syncFrom;
    }

    @Generated
    public static class DefinitionContextBuilder {
        @Generated
        private String origin;
        @Generated
        private String mode;
        @Generated
        private String syncFrom;

        @Generated
        DefinitionContextBuilder() {
        }

        @Generated
        public DefinitionContextBuilder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Generated
        public DefinitionContextBuilder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Generated
        public DefinitionContextBuilder syncFrom(String syncFrom) {
            this.syncFrom = syncFrom;
            return this;
        }

        @Generated
        public DefinitionContext build() {
            return new DefinitionContext(this.origin, this.mode, this.syncFrom);
        }

        @Generated
        public String toString() {
            return "DefinitionContext.DefinitionContextBuilder(origin=" + this.origin + ", mode=" + this.mode + ", syncFrom=" + this.syncFrom + ")";
        }
    }
}

