/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.DefinitionContext;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.Properties;
import io.gravitee.definition.model.Property;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.Service;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.definition.model.services.Services;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;

public class Api
implements Serializable {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="version")
    private String version = "undefined";
    @JsonProperty(value="flow_mode")
    private FlowMode flowMode = FlowMode.DEFAULT;
    @JsonProperty(value="gravitee")
    private DefinitionVersion definitionVersion;
    @JsonProperty(value="definition_context")
    private DefinitionContext definitionContext;
    @JsonProperty(value="proxy")
    private Proxy proxy;
    @JsonProperty(value="services")
    private Services services = new Services();
    @JsonProperty(value="resources")
    private List<Resource> resources = new ArrayList<Resource>();
    @JsonProperty(value="paths")
    private Map<String, List<Rule>> paths;
    @JsonProperty(value="flows")
    private List<Flow> flows;
    @JsonProperty(value="properties")
    private Properties properties;
    @JsonProperty(value="tags")
    private Set<String> tags = new HashSet<String>();
    @JsonProperty(value="path_mappings")
    private Map<String, Pattern> pathMappings = new LinkedHashMap<String, Pattern>();
    @JsonProperty(value="response_templates")
    private Map<String, Map<String, ResponseTemplate>> responseTemplates = new LinkedHashMap<String, Map<String, ResponseTemplate>>();
    @JsonProperty(value="plans")
    private Map<String, Plan> plans = new HashMap<String, Plan>();
    @JsonProperty(value="execution_mode")
    private ExecutionMode executionMode;

    public Api() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Map<String, List<Rule>> getPaths() {
        return this.paths;
    }

    public void setPaths(Map<String, List<Rule>> paths) {
        this.paths = paths;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Services getServices() {
        return this.services;
    }

    public void setServices(Services services) {
        this.services = services;
    }

    public <T extends Service> T getService(Class<T> serviceClass) {
        return this.services.get(serviceClass);
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public Map<String, Pattern> getPathMappings() {
        return this.pathMappings;
    }

    public void setPathMappings(Map<String, Pattern> pathMappings) {
        this.pathMappings = pathMappings;
    }

    public Map<String, Map<String, ResponseTemplate>> getResponseTemplates() {
        return this.responseTemplates;
    }

    public void setResponseTemplates(Map<String, Map<String, ResponseTemplate>> responseTemplates) {
        this.responseTemplates = responseTemplates;
    }

    public FlowMode getFlowMode() {
        return this.flowMode;
    }

    public void setFlowMode(FlowMode flowMode) {
        this.flowMode = flowMode;
    }

    public List<Flow> getFlows() {
        return this.flows;
    }

    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    public DefinitionVersion getDefinitionVersion() {
        return this.definitionVersion;
    }

    public void setDefinitionVersion(DefinitionVersion definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    public Plan getPlan(String plan) {
        return this.plans.get(plan);
    }

    public List<Plan> getPlans() {
        return new ArrayList<Plan>(this.plans.values());
    }

    public void setPlans(List<Plan> plans) {
        this.plans.clear();
        for (Plan plan : plans) {
            this.plans.put(plan.getId(), plan);
        }
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    public DefinitionContext getDefinitionContext() {
        return this.definitionContext;
    }

    public void setDefinitionContext(DefinitionContext definitionContext) {
        this.definitionContext = definitionContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Api api = (Api)o;
        return Objects.equals(this.id, api.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "Api{id='" + this.id + "', name='" + this.name + "', version='" + this.version + "'}";
    }

    @Generated
    public static ApiBuilder builder() {
        return new ApiBuilder();
    }

    @Generated
    public ApiBuilder toBuilder() {
        return new ApiBuilder().id(this.id).name(this.name).version(this.version).flowMode(this.flowMode).definitionVersion(this.definitionVersion).definitionContext(this.definitionContext).proxy(this.proxy).services(this.services).resources(this.resources).paths(this.paths).flows(this.flows).properties(this.properties).tags(this.tags).pathMappings(this.pathMappings).responseTemplates(this.responseTemplates).plans(this.plans).executionMode(this.executionMode);
    }

    @Generated
    public Api(String id, String name, String version, FlowMode flowMode, DefinitionVersion definitionVersion, DefinitionContext definitionContext, Proxy proxy, Services services, List<Resource> resources, Map<String, List<Rule>> paths, List<Flow> flows, Properties properties, Set<String> tags, Map<String, Pattern> pathMappings, Map<String, Map<String, ResponseTemplate>> responseTemplates, Map<String, Plan> plans, ExecutionMode executionMode) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.flowMode = flowMode;
        this.definitionVersion = definitionVersion;
        this.definitionContext = definitionContext;
        this.proxy = proxy;
        this.services = services;
        this.resources = resources;
        this.paths = paths;
        this.flows = flows;
        this.properties = properties;
        this.tags = tags;
        this.pathMappings = pathMappings;
        this.responseTemplates = responseTemplates;
        this.plans = plans;
        this.executionMode = executionMode;
    }

    public static class ApiBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String version;
        @Generated
        private FlowMode flowMode;
        @Generated
        private DefinitionVersion definitionVersion;
        @Generated
        private DefinitionContext definitionContext;
        @Generated
        private Proxy proxy;
        @Generated
        private Services services;
        @Generated
        private List<Resource> resources;
        @Generated
        private Map<String, List<Rule>> paths;
        @Generated
        private List<Flow> flows;
        @Generated
        private Properties properties;
        @Generated
        private Set<String> tags;
        @Generated
        private Map<String, Pattern> pathMappings;
        @Generated
        private Map<String, Map<String, ResponseTemplate>> responseTemplates;
        @Generated
        private Map<String, Plan> plans;
        @Generated
        private ExecutionMode executionMode;

        public ApiBuilder withProperties(Map<String, String> properties) {
            if (properties != null) {
                this.properties = new Properties();
                this.properties.setProperties(properties.entrySet().stream().map(p -> new Property((String)p.getKey(), (String)p.getValue(), false)).collect(Collectors.toList()));
            }
            return this;
        }

        @Generated
        ApiBuilder() {
        }

        @JsonProperty(value="id")
        @Generated
        public ApiBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="name")
        @Generated
        public ApiBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="version")
        @Generated
        public ApiBuilder version(String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="flow_mode")
        @Generated
        public ApiBuilder flowMode(FlowMode flowMode) {
            this.flowMode = flowMode;
            return this;
        }

        @JsonProperty(value="gravitee")
        @Generated
        public ApiBuilder definitionVersion(DefinitionVersion definitionVersion) {
            this.definitionVersion = definitionVersion;
            return this;
        }

        @JsonProperty(value="definition_context")
        @Generated
        public ApiBuilder definitionContext(DefinitionContext definitionContext) {
            this.definitionContext = definitionContext;
            return this;
        }

        @JsonProperty(value="proxy")
        @Generated
        public ApiBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        @JsonProperty(value="services")
        @Generated
        public ApiBuilder services(Services services) {
            this.services = services;
            return this;
        }

        @JsonProperty(value="resources")
        @Generated
        public ApiBuilder resources(List<Resource> resources) {
            this.resources = resources;
            return this;
        }

        @JsonProperty(value="paths")
        @Generated
        public ApiBuilder paths(Map<String, List<Rule>> paths) {
            this.paths = paths;
            return this;
        }

        @JsonProperty(value="flows")
        @Generated
        public ApiBuilder flows(List<Flow> flows) {
            this.flows = flows;
            return this;
        }

        @JsonProperty(value="properties")
        @Generated
        public ApiBuilder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        @JsonProperty(value="tags")
        @Generated
        public ApiBuilder tags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        @JsonProperty(value="path_mappings")
        @Generated
        public ApiBuilder pathMappings(Map<String, Pattern> pathMappings) {
            this.pathMappings = pathMappings;
            return this;
        }

        @JsonProperty(value="response_templates")
        @Generated
        public ApiBuilder responseTemplates(Map<String, Map<String, ResponseTemplate>> responseTemplates) {
            this.responseTemplates = responseTemplates;
            return this;
        }

        @JsonProperty(value="plans")
        @Generated
        public ApiBuilder plans(Map<String, Plan> plans) {
            this.plans = plans;
            return this;
        }

        @JsonProperty(value="execution_mode")
        @Generated
        public ApiBuilder executionMode(ExecutionMode executionMode) {
            this.executionMode = executionMode;
            return this;
        }

        @Generated
        public Api build() {
            return new Api(this.id, this.name, this.version, this.flowMode, this.definitionVersion, this.definitionContext, this.proxy, this.services, this.resources, this.paths, this.flows, this.properties, this.tags, this.pathMappings, this.responseTemplates, this.plans, this.executionMode);
        }

        @Generated
        public String toString() {
            return "Api.ApiBuilder(id=" + this.id + ", name=" + this.name + ", version=" + this.version + ", flowMode=" + this.flowMode + ", definitionVersion=" + this.definitionVersion + ", definitionContext=" + this.definitionContext + ", proxy=" + this.proxy + ", services=" + this.services + ", resources=" + this.resources + ", paths=" + this.paths + ", flows=" + this.flows + ", properties=" + this.properties + ", tags=" + this.tags + ", pathMappings=" + this.pathMappings + ", responseTemplates=" + this.responseTemplates + ", plans=" + this.plans + ", executionMode=" + this.executionMode + ")";
        }
    }
}

