/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.common.mapper;

import io.gravitee.definition.model.v4.ssl.KeyStore;
import io.gravitee.definition.model.v4.ssl.pem.PEMKeyStore;
import io.gravitee.node.vertx.client.ssl.jks.JKSKeyStore;
import io.gravitee.node.vertx.client.ssl.none.NoneKeyStore;
import io.gravitee.node.vertx.client.ssl.pkcs12.PKCS12KeyStore;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

@Mapper
public interface KeyStoreMapper {
    public static final KeyStoreMapper INSTANCE = (KeyStoreMapper)Mappers.getMapper(KeyStoreMapper.class);

    default public io.gravitee.node.vertx.client.ssl.KeyStore map(KeyStore keystore) {
        if (keystore == null) {
            return null;
        }
        return switch (KeyStoreImplementation.get(keystore.getClass().getName()).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.map((PEMKeyStore)keystore);
            case 1 -> this.map((io.gravitee.definition.model.v4.ssl.jks.JKSKeyStore)keystore);
            case 2 -> this.map((io.gravitee.definition.model.v4.ssl.pkcs12.PKCS12KeyStore)keystore);
            case 3 -> this.map((io.gravitee.definition.model.v4.ssl.none.NoneKeyStore)keystore);
        };
    }

    public io.gravitee.node.vertx.client.ssl.pem.PEMKeyStore map(PEMKeyStore var1);

    public JKSKeyStore map(io.gravitee.definition.model.v4.ssl.jks.JKSKeyStore var1);

    public PKCS12KeyStore map(io.gravitee.definition.model.v4.ssl.pkcs12.PKCS12KeyStore var1);

    public NoneKeyStore map(io.gravitee.definition.model.v4.ssl.none.NoneKeyStore var1);

    public static enum KeyStoreImplementation {
        PEM_KEY_STORE(PEMKeyStore.class.getName()),
        JKS_KEY_STORE(io.gravitee.definition.model.v4.ssl.jks.JKSKeyStore.class.getName()),
        PKCS_12_KEY_STORE(io.gravitee.definition.model.v4.ssl.pkcs12.PKCS12KeyStore.class.getName()),
        NONE_KEY_STORE(io.gravitee.definition.model.v4.ssl.none.NoneKeyStore.class.getName());

        private final String className;
        private static final Map<String, KeyStoreImplementation> ENUM_MAP;

        private KeyStoreImplementation(String className) {
            this.className = className;
        }

        public static KeyStoreImplementation get(String name) {
            return ENUM_MAP.get(name);
        }

        static {
            ConcurrentHashMap<String, KeyStoreImplementation> map = new ConcurrentHashMap<String, KeyStoreImplementation>();
            for (KeyStoreImplementation instance : KeyStoreImplementation.values()) {
                map.put(instance.className, instance);
            }
            ENUM_MAP = Collections.unmodifiableMap(map);
        }
    }
}

