/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.common.mapper;

import io.gravitee.definition.model.v4.ssl.jks.JKSTrustStore;
import io.gravitee.definition.model.v4.ssl.pem.PEMTrustStore;
import io.gravitee.node.vertx.client.ssl.TrustStore;
import io.gravitee.node.vertx.client.ssl.none.NoneTrustStore;
import io.gravitee.node.vertx.client.ssl.pkcs12.PKCS12TrustStore;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

@Mapper
public interface TrustStoreMapper {
    public static final TrustStoreMapper INSTANCE = (TrustStoreMapper)Mappers.getMapper(TrustStoreMapper.class);

    default public TrustStore map(io.gravitee.definition.model.v4.ssl.TrustStore trustStore) {
        if (trustStore == null) {
            return null;
        }
        return switch (TrustStoreImplementation.get(trustStore.getClass().getName()).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.map((PEMTrustStore)trustStore);
            case 1 -> this.map((JKSTrustStore)trustStore);
            case 2 -> this.map((io.gravitee.definition.model.v4.ssl.pkcs12.PKCS12TrustStore)trustStore);
            case 3 -> this.map((io.gravitee.definition.model.v4.ssl.none.NoneTrustStore)trustStore);
        };
    }

    public io.gravitee.node.vertx.client.ssl.pem.PEMTrustStore map(PEMTrustStore var1);

    public io.gravitee.node.vertx.client.ssl.jks.JKSTrustStore map(JKSTrustStore var1);

    public PKCS12TrustStore map(io.gravitee.definition.model.v4.ssl.pkcs12.PKCS12TrustStore var1);

    public NoneTrustStore map(io.gravitee.definition.model.v4.ssl.none.NoneTrustStore var1);

    public static enum TrustStoreImplementation {
        PEM_TRUST_STORE(PEMTrustStore.class.getName()),
        JKS_TRUST_STORE(JKSTrustStore.class.getName()),
        PKCS_12_TRUST_STORE(io.gravitee.definition.model.v4.ssl.pkcs12.PKCS12TrustStore.class.getName()),
        NONE_TRUST_STORE(io.gravitee.definition.model.v4.ssl.none.NoneTrustStore.class.getName());

        private final String className;
        private static final Map<String, TrustStoreImplementation> ENUM_MAP;

        private TrustStoreImplementation(String className) {
            this.className = className;
        }

        public static TrustStoreImplementation get(String name) {
            return ENUM_MAP.get(name);
        }

        static {
            ConcurrentHashMap<String, TrustStoreImplementation> map = new ConcurrentHashMap<String, TrustStoreImplementation>();
            for (TrustStoreImplementation instance : TrustStoreImplementation.values()) {
                map.put(instance.className, instance);
            }
            ENUM_MAP = Collections.unmodifiableMap(map);
        }
    }
}

