/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.common.mapper;

import io.gravitee.apim.common.mapper.HttpProxyOptionsMapper;
import io.gravitee.definition.model.v4.http.HttpProxyOptions;
import io.gravitee.definition.model.v4.http.HttpProxyType;
import io.gravitee.node.vertx.client.http.VertxHttpProxyOptions;
import io.gravitee.node.vertx.client.http.VertxHttpProxyType;

public class HttpProxyOptionsMapperImpl
implements HttpProxyOptionsMapper {
    @Override
    public VertxHttpProxyOptions map(HttpProxyOptions httpProxyOptions) {
        if (httpProxyOptions == null) {
            return null;
        }
        VertxHttpProxyOptions.VertxHttpProxyOptionsBuilder vertxHttpProxyOptions = VertxHttpProxyOptions.builder();
        vertxHttpProxyOptions.enabled(httpProxyOptions.isEnabled());
        vertxHttpProxyOptions.useSystemProxy(httpProxyOptions.isUseSystemProxy());
        vertxHttpProxyOptions.host(httpProxyOptions.getHost());
        vertxHttpProxyOptions.port(httpProxyOptions.getPort());
        vertxHttpProxyOptions.username(httpProxyOptions.getUsername());
        vertxHttpProxyOptions.password(httpProxyOptions.getPassword());
        vertxHttpProxyOptions.type(this.httpProxyTypeToVertxHttpProxyType(httpProxyOptions.getType()));
        return vertxHttpProxyOptions.build();
    }

    protected VertxHttpProxyType httpProxyTypeToVertxHttpProxyType(HttpProxyType httpProxyType) {
        if (httpProxyType == null) {
            return null;
        }
        return switch (httpProxyType) {
            case HttpProxyType.HTTP -> VertxHttpProxyType.HTTP;
            case HttpProxyType.SOCKS4 -> VertxHttpProxyType.SOCKS4;
            case HttpProxyType.SOCKS5 -> VertxHttpProxyType.SOCKS5;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + httpProxyType);
        };
    }
}

