/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.alert.api.trigger;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.gravitee.alert.api.condition.Condition;
import io.gravitee.alert.api.condition.Filter;
import io.gravitee.alert.api.condition.projection.Projection;
import io.gravitee.alert.api.trigger.Dampening;
import io.gravitee.common.utils.UUID;
import io.gravitee.notifier.api.Notification;
import io.gravitee.notifier.api.Period;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"id", "name", "source", "enabled", "conditions", "filters", "dampening", "notifications", "metadata"})
public class Trigger
implements Serializable {
    private static final long serialVersionUID = 19504799855563L;
    private String id;
    private Severity severity = Severity.INFO;
    private String source;
    private String name;
    private String description;
    private List<Condition> conditions;
    private List<Notification> notifications;
    private Dampening dampening;
    private Map<String, Map<String, String>> metadata;
    private boolean enabled;
    private List<Filter> filters;
    private List<Period> notificationPeriods;

    @JsonCreator
    protected Trigger(@JsonProperty(value="id", required=true) String id, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="severity") Severity severity, @JsonProperty(value="source", required=true) String source, @JsonProperty(value="enabled") boolean enabled, @JsonProperty(value="notificationPeriods") List<Period> notificationPeriods) {
        this.source = source;
        this.id = id;
        this.name = name;
        this.severity = severity == null ? Severity.INFO : severity;
        this.enabled = enabled;
        this.notificationPeriods = notificationPeriods;
    }

    protected Trigger(String id, String name, Severity severity, String source, boolean enabled) {
        this(id, name, severity, source, enabled, new ArrayList<Period>());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public Map<String, Map<String, String>> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Map<String, String>> metadata) {
        this.metadata = metadata;
    }

    public List<Notification> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<Notification> notifications) {
        this.notifications = notifications;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Dampening getDampening() {
        return this.dampening;
    }

    public void setDampening(Dampening dampening) {
        this.dampening = dampening;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Period> getNotificationPeriods() {
        return this.notificationPeriods;
    }

    public void setNotificationPeriods(List<Period> notificationPeriods) {
        this.notificationPeriods = notificationPeriods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trigger)) {
            return false;
        }
        Trigger trigger = (Trigger)o;
        return Objects.equals(this.id, trigger.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "Trigger{id='" + this.id + '\'' + ", source='" + this.source + '\'' + ", name='" + this.name + '\'' + ", dampening='" + this.dampening + '\'' + ", notifications=" + this.notifications + ", conditions=" + this.conditions + ", notificationPeriods=" + this.notificationPeriods + ", filters=" + this.filters + ", enabled=" + this.enabled + '}';
    }

    public boolean canNotify(long timestamp) {
        List<Period> notificationPeriods = this.getNotificationPeriods();
        if (notificationPeriods == null || notificationPeriods.isEmpty()) {
            return true;
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        return notificationPeriods.stream().anyMatch(period -> period.isIncluded(localDateTime));
    }

    public static Builder on(String source) {
        return new Builder(source);
    }

    public static class Builder {
        private String id;
        private final String source;
        private String name;
        private String description;
        private Severity severity;
        private Map<String, Map<String, String>> metadata;
        private List<Notification> notifications = new ArrayList<Notification>();
        private List<Condition> conditions = new ArrayList<Condition>();
        private List<Projection> projections = new ArrayList<Projection>();
        private List<Filter> filters = new ArrayList<Filter>();
        private List<Period> notificationPeriods = new ArrayList<Period>();
        private boolean enabled = true;
        private Dampening dampening;

        private Builder(String source) {
            this.source = source;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder metadata(String reference, String key, String value) {
            Map<String, String> refMetadata;
            if (this.metadata == null) {
                this.metadata = new HashMap<String, Map<String, String>>();
            }
            if ((refMetadata = this.metadata.get(reference)) == null) {
                refMetadata = new HashMap<String, String>();
                this.metadata.put(reference, refMetadata);
            }
            refMetadata.put(key, value);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder notification(Notification notification) {
            this.notifications.add(notification);
            return this;
        }

        public Builder dampening(Dampening dampening) {
            this.dampening = dampening;
            return this;
        }

        public Builder condition(Condition condition) {
            this.conditions.add(condition);
            return this;
        }

        public Builder filter(Filter filter) {
            if (this.filters == null) {
                this.filters = new ArrayList<Filter>();
            }
            this.filters.add(filter);
            return this;
        }

        public Builder filters(List<Filter> filters) {
            if (filters != null) {
                for (Filter filter : filters) {
                    this.filter(filter);
                }
            }
            return this;
        }

        public Builder notificationPeriod(Period period) {
            if (this.notificationPeriods == null) {
                this.notificationPeriods = new ArrayList<Period>();
            }
            this.notificationPeriods.add(period);
            return this;
        }

        public Builder notificationPeriods(List<Period> periods) {
            if (periods != null) {
                periods.forEach(this::notificationPeriod);
            }
            return this;
        }

        public Trigger build() {
            Trigger trigger = new Trigger(this.id == null ? UUID.random().toString() : this.id, this.name, this.severity, this.source, this.enabled, this.notificationPeriods);
            trigger.setDescription(this.description);
            trigger.setNotifications(this.notifications);
            trigger.setEnabled(this.enabled);
            trigger.setMetadata(this.metadata);
            if (this.conditions == null || this.conditions.isEmpty()) {
                throw new IllegalStateException("A trigger need, at least, one condition defined");
            }
            trigger.setConditions(this.conditions);
            trigger.setFilters(this.filters);
            if (this.dampening != null) {
                trigger.setDampening(this.dampening);
            } else {
                trigger.setDampening(Dampening.strictCount(1));
            }
            return trigger;
        }
    }

    public static enum Severity {
        INFO,
        WARNING,
        CRITICAL;

    }
}

