/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.alert.api.condition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.alert.api.condition.AbstractCondition;
import io.gravitee.alert.api.condition.Condition;
import io.gravitee.alert.api.condition.Filter;

public class ThresholdCondition
extends AbstractCondition
implements Filter {
    private final String property;
    private final Operator operator;
    private final Double threshold;

    @JsonCreator
    private ThresholdCondition(@JsonProperty(value="property", required=true) String property, @JsonProperty(value="operator", required=true) Operator operator, @JsonProperty(value="threshold", required=true) Double threshold) {
        super(Condition.Type.THRESHOLD);
        this.property = property;
        this.operator = operator;
        this.threshold = threshold;
    }

    public static FilterBuilder lowerThan(String property, Double threshold) {
        return new FilterBuilder(property, Operator.LT, threshold);
    }

    public static FilterBuilder lowerThanOrEquals(String property, Double threshold) {
        return new FilterBuilder(property, Operator.LTE, threshold);
    }

    public static FilterBuilder greaterThan(String property, Double threshold) {
        return new FilterBuilder(property, Operator.GT, threshold);
    }

    public static FilterBuilder greaterThanOrEquals(String property, Double threshold) {
        return new FilterBuilder(property, Operator.GTE, threshold);
    }

    public String getProperty() {
        return this.property;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public static class FilterBuilder {
        private final String property;
        private final Operator operator;
        private final Double threshold;

        FilterBuilder(String property, Operator operator, Double threshold) {
            this.property = property;
            this.operator = operator;
            this.threshold = threshold;
        }

        public ThresholdCondition build() {
            return new ThresholdCondition(this.property, this.operator, this.threshold);
        }
    }

    public static enum Operator {
        LT,
        LTE,
        GTE,
        GT;

    }
}

