/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.alert.api.condition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.alert.api.condition.AbstractCondition;
import io.gravitee.alert.api.condition.Condition;
import io.gravitee.alert.api.condition.Filter;
import io.gravitee.alert.api.condition.projection.Projection;
import java.util.List;

public class StringCondition
extends AbstractCondition
implements Filter {
    private final String property;
    private final Operator operator;
    private final boolean ignoreCase;
    private final String pattern;

    @JsonCreator
    private StringCondition(@JsonProperty(value="property", required=true) String property, @JsonProperty(value="operator", required=true) Operator operator, @JsonProperty(value="pattern", required=true) String pattern, @JsonProperty(value="ignoreCase") boolean ignoreCase, @JsonProperty(value="projections") List<Projection> projections) {
        super(Condition.Type.STRING, projections);
        this.property = property;
        this.operator = operator;
        this.pattern = pattern;
        this.ignoreCase = ignoreCase;
    }

    public static FilterBuilder equals(String property, String pattern) {
        return StringCondition.equals(property, pattern, false);
    }

    public static FilterBuilder equals(String property, String pattern, boolean ignoreCase) {
        return new FilterBuilder(property, Operator.EQUALS, pattern, ignoreCase);
    }

    public static FilterBuilder notEquals(String property, String pattern) {
        return StringCondition.notEquals(property, pattern, false);
    }

    public static FilterBuilder notEquals(String property, String pattern, boolean ignoreCase) {
        return new FilterBuilder(property, Operator.NOT_EQUALS, pattern, ignoreCase);
    }

    public static FilterBuilder endsWith(String property, String pattern) {
        return new FilterBuilder(property, Operator.ENDS_WITH, pattern, false);
    }

    public static FilterBuilder contains(String property, String pattern) {
        return new FilterBuilder(property, Operator.CONTAINS, pattern, false);
    }

    public static FilterBuilder matches(String property, String pattern) {
        return StringCondition.matches(property, pattern, false);
    }

    public static FilterBuilder matches(String property, String pattern, boolean ignoreCase) {
        return new FilterBuilder(property, Operator.MATCHES, pattern, ignoreCase);
    }

    public static FilterBuilder startsWith(String property, String pattern) {
        return new FilterBuilder(property, Operator.STARTS_WITH, pattern, false);
    }

    public String getProperty() {
        return this.property;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public String getPattern() {
        return this.pattern;
    }

    public static class FilterBuilder {
        private final String property;
        private final Operator operator;
        private final String pattern;
        private final boolean ignoreCase;
        private List<Projection> projections;

        FilterBuilder(String property, Operator operator, String pattern, boolean ignoreCase) {
            this.property = property;
            this.operator = operator;
            this.pattern = pattern;
            this.ignoreCase = ignoreCase;
        }

        public FilterBuilder projections(List<Projection> projections) {
            this.projections = projections;
            return this;
        }

        public StringCondition build() {
            return new StringCondition(this.property, this.operator, this.pattern, this.ignoreCase, this.projections);
        }
    }

    public static enum Operator {
        EQUALS,
        NOT_EQUALS,
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS,
        MATCHES;

    }
}

