/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.alert.api.condition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.alert.api.condition.AbstractCondition;
import io.gravitee.alert.api.condition.Condition;
import io.gravitee.alert.api.condition.Filter;
import io.gravitee.alert.api.condition.projection.Projection;
import java.util.List;

public class StringCompareCondition
extends AbstractCondition
implements Filter {
    private final String property;
    private final Operator operator;
    private final String property2;
    private final boolean ignoreCase;

    @JsonCreator
    private StringCompareCondition(@JsonProperty(value="property", required=true) String property, @JsonProperty(value="operator", required=true) Operator operator, @JsonProperty(value="property2", required=true) String property2, @JsonProperty(value="ignoreCase") boolean ignoreCase, @JsonProperty(value="projections") List<Projection> projections) {
        super(Condition.Type.STRING_COMPARE, projections);
        this.property = property;
        this.operator = operator;
        this.property2 = property2;
        this.ignoreCase = ignoreCase;
    }

    public static FilterBuilder equals(String property, String property2) {
        return StringCompareCondition.equals(property, property2, false);
    }

    public static FilterBuilder equals(String property, String property2, boolean ignoreCase) {
        return new FilterBuilder(property, Operator.EQUALS, property2, ignoreCase);
    }

    public static FilterBuilder notEquals(String property, String property2) {
        return StringCompareCondition.notEquals(property, property2, false);
    }

    public static FilterBuilder notEquals(String property, String property2, boolean ignoreCase) {
        return new FilterBuilder(property, Operator.NOT_EQUALS, property2, ignoreCase);
    }

    public static FilterBuilder endsWith(String property, String property2) {
        return StringCompareCondition.endsWith(property, property2, false);
    }

    public static FilterBuilder endsWith(String property, String property2, boolean ignoreCase) {
        return new FilterBuilder(property, Operator.ENDS_WITH, property2, ignoreCase);
    }

    public static FilterBuilder contains(String property, String property2) {
        return StringCompareCondition.contains(property, property2, false);
    }

    public static FilterBuilder contains(String property, String pattern, boolean ignoreCase) {
        return new FilterBuilder(property, Operator.CONTAINS, pattern, ignoreCase);
    }

    public static FilterBuilder matches(String property, String pattern) {
        return StringCompareCondition.matches(property, pattern, false);
    }

    public static FilterBuilder matches(String property, String pattern, boolean ignoreCase) {
        return new FilterBuilder(property, Operator.MATCHES, pattern, ignoreCase);
    }

    public static FilterBuilder startsWith(String property, String pattern) {
        return StringCompareCondition.startsWith(property, pattern, false);
    }

    public static FilterBuilder startsWith(String property, String pattern, boolean ignoreCase) {
        return new FilterBuilder(property, Operator.STARTS_WITH, pattern, ignoreCase);
    }

    public String getProperty() {
        return this.property;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getProperty2() {
        return this.property2;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public static class FilterBuilder {
        private final String property;
        private final Operator operator;
        private final String property2;
        private final boolean ignoreCase;
        private List<Projection> projections;

        FilterBuilder(String property, Operator operator, String property2, boolean ignoreCase) {
            this.property = property;
            this.operator = operator;
            this.property2 = property2;
            this.ignoreCase = ignoreCase;
        }

        public FilterBuilder projections(List<Projection> projections) {
            this.projections = projections;
            return this;
        }

        public StringCompareCondition build() {
            return new StringCompareCondition(this.property, this.operator, this.property2, this.ignoreCase, this.projections);
        }
    }

    public static enum Operator {
        EQUALS,
        NOT_EQUALS,
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS,
        MATCHES;

    }
}

