/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.alert.api.condition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.alert.api.condition.AbstractCondition;
import io.gravitee.alert.api.condition.Condition;
import io.gravitee.alert.api.condition.Filter;

public class CompareCondition
extends AbstractCondition
implements Filter {
    private final String property;
    private final Operator operator;
    private final String property2;
    private final Double multiplier;

    @JsonCreator
    private CompareCondition(@JsonProperty(value="property", required=true) String property, @JsonProperty(value="operator", required=true) Operator operator, @JsonProperty(value="multiplier", required=true) Double multiplier, @JsonProperty(value="property2", required=true) String property2) {
        super(Condition.Type.COMPARE);
        this.property = property;
        this.operator = operator;
        this.multiplier = multiplier;
        this.property2 = property2;
    }

    public static FilterBuilder lowerThan(String property, Double multiplier, String property2) {
        return new FilterBuilder(property, Operator.LT, multiplier, property2);
    }

    public static FilterBuilder lowerThanOrEquals(String property, Double multiplier, String property2) {
        return new FilterBuilder(property, Operator.LTE, multiplier, property2);
    }

    public static FilterBuilder greaterThan(String property, Double multiplier, String property2) {
        return new FilterBuilder(property, Operator.GT, multiplier, property2);
    }

    public static FilterBuilder greaterThanOrEquals(String property, Double multiplier, String property2) {
        return new FilterBuilder(property, Operator.GTE, multiplier, property2);
    }

    public String getProperty() {
        return this.property;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getProperty2() {
        return this.property2;
    }

    public Double getMultiplier() {
        return this.multiplier;
    }

    public static class FilterBuilder {
        private final String property;
        private final Operator operator;
        private final String property2;
        private final Double multiplier;

        FilterBuilder(String property, Operator operator, Double multiplier, String property2) {
            this.property = property;
            this.operator = operator;
            this.multiplier = multiplier;
            this.property2 = property2;
        }

        public CompareCondition build() {
            return new CompareCondition(this.property, this.operator, this.multiplier, this.property2);
        }
    }

    public static enum Operator {
        LT,
        LTE,
        GTE,
        GT;

    }
}

