/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.alert.api.event;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.gravitee.alert.api.event.AbstractEvent;
import io.gravitee.alert.api.event.Event;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DefaultEvent
extends AbstractEvent
implements Serializable {
    private static final long serialVersionUID = 1379928246655907008L;
    private Map<String, String> context;
    private Map<String, Object> properties;

    protected DefaultEvent(long timestamp, String type) {
        super(timestamp, type);
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public String getId() {
        return this.id();
    }

    public String getType() {
        return this.type();
    }

    public long getTimestamp() {
        return this.timestamp();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultEvent)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode());
    }

    @Override
    public Map<String, String> context() {
        return this.context;
    }

    @Override
    public Map<String, Object> properties() {
        return this.properties;
    }

    public static class Builder {
        private final long timestamp;
        private String type;
        private Map<String, String> context;
        private Map<String, Object> props;

        Builder(long timestamp) {
            this.timestamp = timestamp;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder context(String key, String value) {
            if (this.context == null) {
                this.context = new LinkedHashMap<String, String>();
            }
            this.context.put(key, value);
            return this;
        }

        public Builder context(String key, Supplier<String> supplier) {
            String value = supplier.get();
            if (value != null) {
                this.context(key, value);
            }
            return this;
        }

        public Builder property(String key, Object value) {
            if (this.props == null) {
                this.props = new LinkedHashMap<String, Object>();
            }
            this.props.put(key, value);
            return this;
        }

        public Builder property(String key, Supplier supplier) {
            Object value = supplier.get();
            if (value != null) {
                this.property(key, value);
            }
            return this;
        }

        public Event build() {
            Objects.requireNonNull(this.type, "Event's type is required");
            DefaultEvent alertEvent = new DefaultEvent(this.timestamp, this.type);
            alertEvent.setContext(this.context);
            alertEvent.setProperties(this.props);
            return alertEvent;
        }
    }
}

