/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.alert.api.condition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.gravitee.alert.api.condition.AbstractCondition;
import io.gravitee.alert.api.condition.Condition;
import java.util.concurrent.TimeUnit;

public class WindowBasedCondition
extends AbstractCondition {
    private final long duration;
    private final TimeUnit timeUnit;

    WindowBasedCondition(Condition.Type type, TimeUnit timeUnit, long duration) {
        super(type);
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @JsonIgnore
    public long getWindowTime() {
        return this.timeUnit != null ? this.timeUnit.toMillis(this.duration) : this.duration;
    }
}

