/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.alert.api.condition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.alert.api.condition.Condition;
import io.gravitee.alert.api.condition.Filter;
import io.gravitee.alert.api.condition.ProjectionsAwareCondition;
import io.gravitee.alert.api.condition.projection.Projection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MissingDataCondition
extends ProjectionsAwareCondition
implements Filter {
    @JsonCreator
    private MissingDataCondition(@JsonProperty(value="duration", required=true) long duration, @JsonProperty(value="timeUnit") TimeUnit timeUnit, @JsonProperty(value="projections") List<Projection> projections) {
        super(Condition.Type.MISSING_DATA, timeUnit, duration, projections);
    }

    public static DurationBuilder duration(long duration, TimeUnit timeUnit) {
        return new DurationBuilder(duration, timeUnit);
    }

    public static DurationBuilder duration(long duration) {
        return new DurationBuilder(duration);
    }

    public static class DurationBuilder {
        private final long duration;
        private final TimeUnit timeUnit;
        private List<Projection> projections;

        DurationBuilder(long duration, TimeUnit timeUnit) {
            this.duration = duration;
            this.timeUnit = timeUnit;
        }

        DurationBuilder(long duration) {
            this(duration, null);
        }

        public DurationBuilder projection(Projection projection) {
            if (this.projections == null) {
                this.projections = new ArrayList<Projection>();
            }
            this.projections.add(projection);
            return this;
        }

        public MissingDataCondition build() {
            return new MissingDataCondition(this.duration, this.timeUnit, this.projections);
        }
    }
}

