/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdRule;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/NestedBlockDepth;", "Lio/gitlab/arturbosch/detekt/api/ThresholdRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "threshold", "", "(Lio/gitlab/arturbosch/detekt/api/Config;I)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Companion", "FunctionDepthVisitor", "detekt-rules-complexity"})
public final class NestedBlockDepth
extends ThresholdRule {
    @NotNull
    private final Issue issue;
    public static final int DEFAULT_THRESHOLD_NESTING = 4;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        FunctionDepthVisitor visitor = new FunctionDepthVisitor(this.getThreshold());
        visitor.visitNamedFunction(function);
        if (visitor.isTooDeep()) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), new Metric("SIZE", visitor.getMaxDepth(), this.getThreshold(), false, 0, 24, null), "Function " + function.getName() + " is nested too deeply.", null, 16, null));
        }
    }

    public NestedBlockDepth(@NotNull Config config, int threshold) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, threshold);
        this.issue = new Issue("NestedBlockDepth", Severity.Maintainability, "Excessive nesting leads to hidden complexity. Prefer extracting code to make it easier to understand.", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ NestedBlockDepth(Config config, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        this(config, n);
    }

    public NestedBlockDepth() {
        this(null, 0, 3, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J$\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020&H\u0016R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0007\"\u0004\b\u0010\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006'"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/NestedBlockDepth$FunctionDepthVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "threshold", "", "(I)V", "depth", "getDepth", "()I", "setDepth", "isTooDeep", "", "()Z", "setTooDeep", "(Z)V", "maxDepth", "getMaxDepth", "setMaxDepth", "getThreshold", "dec", "", "inc", "insideLambdaDo", "lambdaArguments", "", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "function", "Lkotlin/Function0;", "visitCallExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitLoopExpression", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "detekt-rules-complexity"})
    private static final class FunctionDepthVisitor
    extends DetektVisitor {
        private int depth;
        private int maxDepth;
        private boolean isTooDeep;
        private final int threshold;

        public final int getDepth() {
            return this.depth;
        }

        public final void setDepth(int n) {
            this.depth = n;
        }

        public final int getMaxDepth() {
            return this.maxDepth;
        }

        public final void setMaxDepth(int n) {
            this.maxDepth = n;
        }

        public final boolean isTooDeep() {
            return this.isTooDeep;
        }

        public final void setTooDeep(boolean bl) {
            this.isTooDeep = bl;
        }

        private final void inc() {
            int n = this.depth;
            this.depth = n + 1;
            if (this.depth >= this.threshold) {
                this.isTooDeep = true;
                if (this.depth > this.maxDepth) {
                    this.maxDepth = this.depth;
                }
            }
        }

        private final void dec() {
            int n = this.depth;
            this.depth = n + -1;
        }

        public void visitIfExpression(@NotNull KtIfExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (!(expression.getParent() instanceof KtContainerNodeForControlStructureBody)) {
                this.inc();
                super.visitIfExpression(expression);
                this.dec();
            } else {
                super.visitIfExpression(expression);
            }
        }

        public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
            Intrinsics.checkNotNullParameter((Object)loopExpression, (String)"loopExpression");
            this.inc();
            super.visitLoopExpression(loopExpression);
            this.dec();
        }

        public void visitWhenExpression(@NotNull KtWhenExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.inc();
            super.visitWhenExpression(expression);
            this.dec();
        }

        public void visitTryExpression(@NotNull KtTryExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.inc();
            super.visitTryExpression(expression);
            this.dec();
        }

        public void visitCallExpression(@NotNull KtCallExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            List list = expression.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expression.lambdaArguments");
            List lambdaArguments = list;
            if (JunkKt.isUsedForNesting((KtCallExpression)expression)) {
                this.insideLambdaDo(lambdaArguments, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ FunctionDepthVisitor this$0;

                    public final void invoke() {
                        FunctionDepthVisitor.access$inc(this.this$0);
                    }
                    {
                        this.this$0 = functionDepthVisitor;
                        super(0);
                    }
                }));
                super.visitCallExpression(expression);
                this.insideLambdaDo(lambdaArguments, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ FunctionDepthVisitor this$0;

                    public final void invoke() {
                        FunctionDepthVisitor.access$dec(this.this$0);
                    }
                    {
                        this.this$0 = functionDepthVisitor;
                        super(0);
                    }
                }));
            }
        }

        private final void insideLambdaDo(List<KtLambdaArgument> lambdaArguments, Function0<Unit> function) {
            block0: {
                KtLambdaArgument lambdaArgument;
                KtLambdaExpression ktLambdaExpression;
                Collection collection = lambdaArguments;
                boolean bl = false;
                if (!(!collection.isEmpty()) || (ktLambdaExpression = (lambdaArgument = lambdaArguments.get(0)).getLambdaExpression()) == null || (ktLambdaExpression = ktLambdaExpression.getBodyExpression()) == null) break block0;
                KtLambdaExpression ktLambdaExpression2 = ktLambdaExpression;
                boolean bl2 = false;
                boolean bl3 = false;
                KtLambdaExpression it = ktLambdaExpression2;
                boolean bl4 = false;
                function.invoke();
            }
        }

        public final int getThreshold() {
            return this.threshold;
        }

        public FunctionDepthVisitor(int threshold) {
            this.threshold = threshold;
        }

        public static final /* synthetic */ void access$inc(FunctionDepthVisitor $this) {
            $this.inc();
        }

        public static final /* synthetic */ void access$dec(FunctionDepthVisitor $this) {
            $this.dec();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/NestedBlockDepth$Companion;", "", "()V", "DEFAULT_THRESHOLD_NESTING", "", "detekt-rules-complexity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

