/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.parser;

import io.github.detekt.parser.KotlinEnvironmentUtilsKt;
import io.github.detekt.parser.KtCompilerKt;
import io.github.detekt.psi.KeysKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lio/github/detekt/parser/KtCompiler;", "", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)V", "getEnvironment", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "psiFileFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "getPsiFileFactory", "()Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "compile", "Lorg/jetbrains/kotlin/psi/KtFile;", "basePath", "Ljava/nio/file/Path;", "path", "createKtFile", "content", "", "detekt-parser"})
public class KtCompiler {
    @NotNull
    private final KtPsiFactory psiFileFactory;
    @NotNull
    private final KotlinCoreEnvironment environment;

    @NotNull
    protected final KtPsiFactory getPsiFileFactory() {
        return this.psiFileFactory;
    }

    @NotNull
    public final KtFile compile(@NotNull Path basePath, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)basePath, (String)"basePath");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        boolean bl = Files.isRegularFile(path, new LinkOption[0]);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Given sub path (" + path + ") should be a regular file!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        File file = path.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"path.toFile()");
        String content = FilesKt.readText$default((File)file, null, (int)1, null);
        return this.createKtFile(content, basePath, path);
    }

    @NotNull
    public final KtFile createKtFile(@NotNull String content, @NotNull Path basePath, @NotNull Path path) {
        KtFile psiFile;
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)basePath, (String)"basePath");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        boolean bl = Files.isRegularFile(path, new LinkOption[0]);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Given sub path (" + path + ") should be a regular file!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Path relativePath = (Intrinsics.areEqual((Object)basePath, (Object)path) ? path.getFileName() : basePath.getFileName().resolve(basePath.relativize(path))).normalize();
        Path absolutePath = path.toAbsolutePath().normalize();
        String lineSeparator = KtCompilerKt.determineLineSeparator(content);
        String string = ((Object)absolutePath).toString();
        String string2 = StringUtilRt.convertLineSeparators((String)content);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtilRt.convertLineSeparators(content)");
        KtFile ktFile = psiFile = this.psiFileFactory.createPhysicalFile(string, string2);
        boolean bl5 = false;
        boolean bl6 = false;
        KtFile $this$apply = ktFile;
        boolean bl7 = false;
        $this$apply.putUserData(KeysKt.getLINE_SEPARATOR(), (Object)lineSeparator);
        $this$apply.putUserData(KeysKt.getRELATIVE_PATH(), (Object)((Object)relativePath).toString());
        return ktFile;
    }

    @NotNull
    protected final KotlinCoreEnvironment getEnvironment() {
        return this.environment;
    }

    public KtCompiler(@NotNull KotlinCoreEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        this.environment = environment;
        this.psiFileFactory = new KtPsiFactory(this.environment.getProject(), false);
    }

    public /* synthetic */ KtCompiler(KotlinCoreEnvironment kotlinCoreEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            kotlinCoreEnvironment = KotlinEnvironmentUtilsKt.createKotlinCoreEnvironment$default(null, null, 3, null);
        }
        this(kotlinCoreEnvironment);
    }

    public KtCompiler() {
        this(null, 1, null);
    }
}

