/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli;

import io.github.detekt.tooling.api.AnalysisResult;
import io.github.detekt.tooling.api.AnalysisResultKt;
import io.github.detekt.tooling.api.DetektError;
import io.github.detekt.tooling.api.InvalidConfig;
import io.github.detekt.tooling.api.MaxIssuesReached;
import io.github.detekt.tooling.api.UnexpectedError;
import io.github.detekt.tooling.internal.NotApiButProbablyUsedByUsers;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.CliRunner;
import io.gitlab.arturbosch.detekt.cli.HandledArgumentViolation;
import io.gitlab.arturbosch.detekt.cli.HelpRequest;
import io.gitlab.arturbosch.detekt.cli.JCommanderKt;
import io.gitlab.arturbosch.detekt.cli.runners.AstPrinter;
import io.gitlab.arturbosch.detekt.cli.runners.ConfigExporter;
import io.gitlab.arturbosch.detekt.cli.runners.Executable;
import io.gitlab.arturbosch.detekt.cli.runners.Runner;
import io.gitlab.arturbosch.detekt.cli.runners.VersionPrinter;
import java.io.PrintStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a+\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u001a\u0019\u0010\t\u001a\u00020\n2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"buildRunner", "Lio/gitlab/arturbosch/detekt/cli/runners/Executable;", "args", "", "", "outputPrinter", "Ljava/io/PrintStream;", "errorPrinter", "([Ljava/lang/String;Ljava/io/PrintStream;Ljava/io/PrintStream;)Lio/gitlab/arturbosch/detekt/cli/runners/Executable;", "main", "", "([Ljava/lang/String;)V", "detekt-cli"})
@JvmName(name="Main")
public final class Main {
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        AnalysisResult result = new CliRunner().run(args);
        DetektError error = result.getError();
        if (error instanceof InvalidConfig || error instanceof MaxIssuesReached) {
            String string = error.getMessage();
            boolean bl = false;
            System.out.println((Object)string);
        } else if (error instanceof UnexpectedError) {
            Throwable cause = ((UnexpectedError)error).getCause();
            if (cause instanceof HelpRequest) {
                String string = ((HelpRequest)cause).getUsageText();
                boolean bl = false;
                System.out.println((Object)string);
                int n = 0;
                bl = false;
                System.exit(n);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            if (cause instanceof HandledArgumentViolation) {
                String string = cause.getMessage();
                boolean bl = false;
                System.out.println((Object)string);
                string = ((HandledArgumentViolation)cause).getUsageText();
                bl = false;
                System.out.println((Object)string);
            } else {
                cause.printStackTrace();
            }
        }
        int n = AnalysisResultKt.exitCode((AnalysisResult)result);
        boolean bl = false;
        System.exit(n);
        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    @NotApiButProbablyUsedByUsers
    @Deprecated(message="Don't build a runner yourself.", replaceWith=@ReplaceWith(imports={"io.github.detekt.tooling.api.DetektCli"}, expression="DetektCli.load().run(args, outputPrinter, errorPrinter)"))
    @NotNull
    public static final Executable buildRunner(@NotNull String[] args, @NotNull PrintStream outputPrinter, @NotNull PrintStream errorPrinter) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)outputPrinter, (String)"outputPrinter");
        Intrinsics.checkNotNullParameter((Object)errorPrinter, (String)"errorPrinter");
        CliArgs arguments = JCommanderKt.parseArguments(args);
        return arguments.getShowVersion() ? (Executable)new VersionPrinter(outputPrinter) : (arguments.getGenerateConfig() ? (Executable)new ConfigExporter(arguments, outputPrinter) : (arguments.getPrintAst() ? (Executable)new AstPrinter(arguments, outputPrinter) : (Executable)new Runner(arguments, outputPrinter, errorPrinter)));
    }
}

