/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli.runners;

import io.github.detekt.tooling.api.DefaultConfigurationProvider;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.runners.Executable;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/cli/runners/ConfigExporter;", "Lio/gitlab/arturbosch/detekt/cli/runners/Executable;", "arguments", "Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "outputPrinter", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "(Lio/gitlab/arturbosch/detekt/cli/CliArgs;Ljava/lang/Appendable;)V", "execute", "", "detekt-cli"})
public final class ConfigExporter
implements Executable {
    private final CliArgs arguments;
    private final Appendable outputPrinter;

    @Override
    public void execute() {
        String string = this.arguments.getConfig();
        if (string == null) {
            string = "detekt.yml";
        }
        Path configPath = Paths.get(string, new String[0]);
        DefaultConfigurationProvider defaultConfigurationProvider = DefaultConfigurationProvider.Companion.load$default((DefaultConfigurationProvider.Companion)DefaultConfigurationProvider.Companion, null, (int)1, null);
        Path path = configPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"configPath");
        defaultConfigurationProvider.copy(path);
        Appendable appendable = this.outputPrinter;
        CharSequence charSequence = "Successfully copied default config to " + configPath.toAbsolutePath();
        boolean bl = false;
        Appendable appendable2 = appendable.append(charSequence);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable2, (String)"append(value)");
        StringsKt.appendln((Appendable)appendable2);
    }

    public ConfigExporter(@NotNull CliArgs arguments, @NotNull Appendable outputPrinter) {
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        Intrinsics.checkParameterIsNotNull((Object)outputPrinter, (String)"outputPrinter");
        this.arguments = arguments;
        this.outputPrinter = outputPrinter;
    }
}

