/*
 * Decompiled with CFR 0.152.
 */
package com.android.base.image.glide;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.android.base.image.DisplayConfig;
import com.android.base.image.ImageLoader;
import com.android.base.image.LoadListener;
import com.android.base.image.ProgressListener;
import com.android.base.image.Source;
import com.android.base.image.glide.ProgressManager;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.ImageViewTarget;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;

public class GlideImageLoader
implements ImageLoader {
    private boolean canFragmentLoadImage(Fragment fragment) {
        return fragment.isResumed() || fragment.isAdded() || fragment.isVisible();
    }

    @Override
    public void display(Fragment fragment, ImageView imageView, String url, LoadListener<Drawable> loadListener) {
        if (this.canFragmentLoadImage(fragment)) {
            Glide.with((Fragment)fragment).load(url).into((Target)new InnerImageTarget(imageView, url, loadListener));
        }
    }

    @Override
    public void display(Fragment fragment, ImageView imageView, String url, DisplayConfig displayConfig, LoadListener<Drawable> loadListener) {
        if (!this.canFragmentLoadImage(fragment)) {
            return;
        }
        RequestBuilder requestBuilder = Glide.with((Fragment)fragment).load(url);
        if (displayConfig != null) {
            RequestOptions requestOptions = this.buildRequestOptions(displayConfig);
            requestBuilder = requestBuilder.apply((BaseRequestOptions)requestOptions);
            if (displayConfig.getThumbnail() != 0.0f) {
                requestBuilder = requestBuilder.thumbnail(displayConfig.getThumbnail());
            }
        }
        requestBuilder.into((Target)new InnerImageTarget(imageView, url, loadListener));
    }

    @Override
    public void display(ImageView imageView, String url, LoadListener<Drawable> loadListener) {
        Glide.with((Context)imageView.getContext()).load(url).into((Target)new InnerImageTarget(imageView, url, loadListener));
    }

    @Override
    public void display(ImageView imageView, String url, DisplayConfig config, LoadListener<Drawable> loadListener) {
        RequestBuilder requestBuilder = Glide.with((Context)imageView.getContext()).load(url);
        if (config != null) {
            RequestOptions requestOptions = this.buildRequestOptions(config);
            requestBuilder = requestBuilder.apply((BaseRequestOptions)requestOptions);
            if (config.getThumbnail() != 0.0f) {
                requestBuilder = requestBuilder.thumbnail(config.getThumbnail());
            }
        }
        requestBuilder.into((Target)new InnerImageTarget(imageView, url, loadListener));
    }

    @Override
    public void removeAllListener(String url) {
        ProgressManager.getInstance().removeListener(url);
    }

    @Override
    public void addListener(@NonNull String url, @NonNull ProgressListener progressListener) {
        ProgressManager.getInstance().addLoadListener(url, progressListener);
    }

    @Override
    public void setListener(String url, ProgressListener progressListener) {
        ProgressManager.getInstance().setListener(url, progressListener);
    }

    @Override
    public void display(Fragment fragment, ImageView imageView, String url) {
        if (this.canFragmentLoadImage(fragment)) {
            Glide.with((Fragment)fragment).load(url).into(imageView);
        }
    }

    @Override
    public void display(Fragment fragment, ImageView imageView, String url, DisplayConfig displayConfig) {
        this.display(imageView, Glide.with((Fragment)fragment).load(url), displayConfig);
    }

    @Override
    public void display(Fragment fragment, ImageView imageView, Source source) {
        this.display(fragment, imageView, source, null);
    }

    @Override
    public void display(Fragment fragment, ImageView imageView, Source source, DisplayConfig displayConfig) {
        if (!this.canFragmentLoadImage(fragment)) {
            return;
        }
        RequestManager requestManager = Glide.with((Fragment)fragment);
        RequestBuilder<?> drawableTypeRequest = this.setToRequest(requestManager, source);
        this.display(imageView, drawableTypeRequest, displayConfig);
    }

    @Override
    public void display(ImageView imageView, String url) {
        this.display(imageView, Glide.with((Context)imageView.getContext()).load(url), null);
    }

    @Override
    public void display(ImageView imageView, String url, DisplayConfig config) {
        this.display(imageView, Glide.with((Context)imageView.getContext()).load(url), config);
    }

    @Override
    public void display(ImageView imageView, Source source) {
        RequestBuilder<?> drawableTypeRequest = this.setToRequest(Glide.with((Context)imageView.getContext()), source);
        this.display(imageView, drawableTypeRequest, null);
    }

    @Override
    public void display(ImageView imageView, Source source, DisplayConfig config) {
        RequestBuilder<?> drawableTypeRequest = this.setToRequest(Glide.with((Context)imageView.getContext()), source);
        this.display(imageView, drawableTypeRequest, config);
    }

    private void display(ImageView imageView, RequestBuilder request, DisplayConfig displayConfig) {
        if (displayConfig != null) {
            RequestOptions requestOptions = this.buildRequestOptions(displayConfig);
            request = request.apply((BaseRequestOptions)requestOptions);
            if (displayConfig.getThumbnail() != 0.0f) {
                request = request.thumbnail(displayConfig.getThumbnail());
            }
        }
        request.into(imageView);
    }

    @Override
    public void pause(Fragment fragment) {
        Glide.with((Fragment)fragment).pauseRequests();
    }

    @Override
    public void resume(Fragment fragment) {
        Glide.with((Fragment)fragment).resumeRequests();
    }

    @Override
    public void pause(Context context) {
        Glide.with((Context)context).pauseRequests();
    }

    @Override
    public void resume(Context context) {
        Glide.with((Context)context).resumeRequests();
    }

    @Override
    public void preload(Context context, Source source) {
        RequestManager requestManager = Glide.with((Context)context);
        this.setToRequest(requestManager, source).preload();
    }

    @Override
    public void preload(Context context, Source source, int width, int height) {
        RequestManager requestManager = Glide.with((Context)context);
        this.setToRequest(requestManager, source).preload(width, height);
    }

    @Override
    public void clear(Context context) {
        Glide.get((Context)context).clearDiskCache();
    }

    @Override
    public void clear(View view) {
        Context context = view.getContext();
        if (context != null) {
            Glide.with((Context)context).clear(view);
        }
    }

    @Override
    public void clear(Fragment fragment, View view) {
        Glide.with((Fragment)fragment).clear(view);
    }

    @Override
    public void loadBitmap(Context context, Source source, boolean cache, LoadListener<Bitmap> bitmapLoadListener) {
        this.loadBitmap(context, source, cache, 0, 0, bitmapLoadListener);
    }

    @Override
    public void loadBitmap(Fragment fragment, Source source, boolean cache, LoadListener<Bitmap> bitmapLoadListener) {
        this.loadBitmap(fragment, source, cache, 0, 0, bitmapLoadListener);
    }

    @Override
    public void loadBitmap(Fragment fragment, Source source, boolean cache, int width, int height, LoadListener<Bitmap> bitmapLoadListener) {
        this.loadBitmapInternal(Glide.with((Fragment)fragment), source, cache, width, height, bitmapLoadListener);
    }

    @Override
    public Bitmap loadBitmap(Context context, Source source, boolean cache, int width, int height) {
        RequestBuilder requestBuilder = Glide.with((Context)context).asBitmap();
        requestBuilder = this.setToRequest(requestBuilder, source);
        if (width > 0 && height > 0) {
            try {
                return (Bitmap)requestBuilder.submit(width, height).get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            try {
                return (Bitmap)requestBuilder.submit().get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void loadBitmap(Context context, Source source, boolean cache, int width, int height, LoadListener<Bitmap> bitmapLoadListener) {
        this.loadBitmapInternal(Glide.with((Context)context), source, cache, width, height, bitmapLoadListener);
    }

    private void loadBitmapInternal(RequestManager requestManager, Source source, boolean cache, int width, int height, final LoadListener<Bitmap> bitmapLoadListener) {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions = cache ? (RequestOptions)((RequestOptions)requestOptions.skipMemoryCache(false)).diskCacheStrategy(DiskCacheStrategy.ALL) : (RequestOptions)((RequestOptions)requestOptions.skipMemoryCache(true)).diskCacheStrategy(DiskCacheStrategy.NONE);
        if (width > 0 && height > 0) {
            requestOptions = (RequestOptions)requestOptions.override(width, height);
        }
        RequestBuilder requestBuilder = requestManager.asBitmap().apply((BaseRequestOptions)requestOptions);
        requestBuilder = this.setToRequest(requestBuilder, source);
        requestBuilder.into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(@NotNull Bitmap resource, Transition<? super Bitmap> transition) {
                bitmapLoadListener.onLoadSuccess(resource);
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                bitmapLoadListener.onLoadFail();
            }

            public void onLoadStarted(@Nullable Drawable placeholder) {
                bitmapLoadListener.onLoadStart();
            }
        });
    }

    private RequestOptions buildRequestOptions(DisplayConfig displayConfig) {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions = displayConfig.isCacheDisk() ? (RequestOptions)requestOptions.diskCacheStrategy(DiskCacheStrategy.ALL) : (RequestOptions)requestOptions.diskCacheStrategy(DiskCacheStrategy.NONE);
        requestOptions = displayConfig.isCacheMemory() ? (RequestOptions)requestOptions.skipMemoryCache(false) : (RequestOptions)requestOptions.skipMemoryCache(true);
        if (displayConfig.getScaleType() == 1) {
            requestOptions = (RequestOptions)requestOptions.centerCrop();
        } else if (displayConfig.getScaleType() == 2) {
            requestOptions = (RequestOptions)requestOptions.fitCenter();
        }
        if (displayConfig.getTransform() == 2) {
            requestOptions = (RequestOptions)requestOptions.circleCrop();
        } else if (displayConfig.getTransform() == 3) {
            requestOptions = (RequestOptions)requestOptions.transform((Transformation)new RoundedCorners(displayConfig.getRoundedCornersRadius()));
        } else if (displayConfig.getTransform() == 1) {
            requestOptions = (RequestOptions)requestOptions.dontTransform();
        }
        if (displayConfig.getErrorPlaceholder() != -1) {
            requestOptions = (RequestOptions)requestOptions.error(displayConfig.getErrorPlaceholder());
        }
        if (displayConfig.getErrorDrawable() != null) {
            requestOptions = (RequestOptions)requestOptions.error(displayConfig.getErrorDrawable());
        }
        if (displayConfig.getLoadingPlaceholder() != -1) {
            requestOptions = (RequestOptions)requestOptions.placeholder(displayConfig.getLoadingPlaceholder());
        }
        if (displayConfig.getLoadingDrawable() != null) {
            requestOptions = (RequestOptions)requestOptions.placeholder(displayConfig.getLoadingDrawable());
        }
        if (displayConfig.getHeight() > 0 && displayConfig.getWidth() > 0) {
            requestOptions = (RequestOptions)requestOptions.override(displayConfig.getWidth(), displayConfig.getHeight());
        }
        return requestOptions;
    }

    private RequestBuilder<?> setToRequest(RequestManager requestManager, Source source) {
        if (source.getFile() != null) {
            return requestManager.load(source.getFile());
        }
        if (source.getUrl() != null) {
            return requestManager.load(source.getUrl());
        }
        if (source.getResource() != 0) {
            return requestManager.load(Integer.valueOf(source.getResource()));
        }
        if (source.getUri() != null) {
            return requestManager.load(source.getUri());
        }
        if (source.getBytes() != null) {
            return requestManager.load(source.getBytes());
        }
        throw new IllegalArgumentException("UnSupport source");
    }

    private <T> RequestBuilder<T> setToRequest(RequestBuilder<T> requestBuilder, Source source) {
        if (source.getFile() != null) {
            return requestBuilder.load(source.getFile());
        }
        if (source.getUrl() != null) {
            return requestBuilder.load(source.getUrl());
        }
        if (source.getResource() != 0) {
            return requestBuilder.load(Integer.valueOf(source.getResource()));
        }
        if (source.getUri() != null) {
            return requestBuilder.load(source.getUri());
        }
        if (source.getBytes() != null) {
            return requestBuilder.load(source.getBytes());
        }
        throw new IllegalArgumentException("UnSupport source");
    }

    private static class InnerImageTarget
    extends ImageViewTarget<Drawable> {
        private final LoadListener<Drawable> mLoadListener;

        InnerImageTarget(ImageView view, String url, LoadListener<Drawable> loadListener) {
            super(view);
            this.mLoadListener = loadListener;
        }

        protected void setResource(@Nullable Drawable resource) {
            ((ImageView)this.getView()).setImageDrawable(resource);
        }

        public void onResourceReady(@NotNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
            super.onResourceReady((Object)resource, transition);
            this.mLoadListener.onLoadSuccess(resource);
        }

        public void onLoadStarted(@Nullable Drawable placeholder) {
            this.mLoadListener.onLoadStart();
            super.onLoadStarted(placeholder);
        }

        public void onLoadFailed(@Nullable Drawable errorDrawable) {
            super.onLoadFailed(errorDrawable);
            this.mLoadListener.onLoadFail();
        }
    }
}

