/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhitaocai.toastcompat;

import android.content.Context;
import android.view.View;
import io.github.zhitaocai.toastcompat.IToast;
import io.github.zhitaocai.toastcompat.MIUIToast;
import io.github.zhitaocai.toastcompat.SystemToast;
import io.github.zhitaocai.toastcompat.util.DisplayUtil;
import io.github.zhitaocai.toastcompat.util.OSJudgementUtil;

public class ToastCompat
implements IToast {
    private IToast mIToast;

    public ToastCompat(Context context) {
        this(context, null, -1);
    }

    ToastCompat(Context context, String text, int duration) {
        this.mIToast = OSJudgementUtil.isMIUI() ? new MIUIToast(context).setText(text).setDuration(duration).setGravity(80, 0, DisplayUtil.dip2px(context, 64.0f)) : new SystemToast(context).setText(text).setDuration(duration);
    }

    public static IToast makeText(Context context, String text, int duration) {
        return new ToastCompat(context, text, duration);
    }

    @Override
    public IToast setGravity(int gravity, int xOffset, int yOffset) {
        return this.mIToast.setGravity(gravity, xOffset, yOffset);
    }

    @Override
    public IToast setDuration(long durationMillis) {
        return this.mIToast.setDuration(durationMillis);
    }

    @Override
    public IToast setView(View view) {
        return this.mIToast.setView(view);
    }

    @Override
    public IToast setMargin(float horizontalMargin, float verticalMargin) {
        return this.mIToast.setMargin(horizontalMargin, verticalMargin);
    }

    @Override
    public IToast setText(String text) {
        return this.mIToast.setText(text);
    }

    @Override
    public void show() {
        this.mIToast.show();
    }

    @Override
    public void cancel() {
        this.mIToast.cancel();
    }
}

