/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhitaocai.toastcompat;

import android.content.Context;
import android.view.View;
import android.widget.Toast;
import io.github.zhitaocai.toastcompat.IToast;

public class SystemToast
implements IToast {
    private Toast mToast;
    private Context mContext;

    public static IToast makeText(Context context, String text, long duration) {
        return new SystemToast(context).setText(text).setDuration(duration);
    }

    public SystemToast(Context context) {
        this.mContext = context;
        this.mToast = Toast.makeText((Context)context, (CharSequence)"", (int)0);
    }

    @Override
    public IToast setGravity(int gravity, int xOffset, int yOffset) {
        this.mToast.setGravity(gravity, xOffset, yOffset);
        return this;
    }

    @Override
    public IToast setDuration(long durationMillis) {
        this.mToast.setDuration((int)durationMillis);
        return this;
    }

    @Override
    public IToast setView(View view) {
        this.mToast.setView(view);
        return this;
    }

    @Override
    public IToast setMargin(float horizontalMargin, float verticalMargin) {
        this.mToast.setMargin(horizontalMargin, verticalMargin);
        return this;
    }

    @Override
    public IToast setText(String text) {
        this.mToast.setText((CharSequence)text);
        return this;
    }

    @Override
    public void show() {
        if (this.mToast != null) {
            this.mToast.show();
        }
    }

    @Override
    public void cancel() {
        if (this.mToast != null) {
            this.mToast.cancel();
        }
    }
}

