/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhitaocai.toastcompat;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Handler;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;
import android.widget.Toast;
import io.github.zhitaocai.toastcompat.IToast;
import io.github.zhitaocai.toastcompat.util.DisplayUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class MIUIToast
implements IToast {
    private static Handler mHandler = new Handler();
    private static BlockingQueue<MIUIToast> mQueue = new LinkedBlockingQueue<MIUIToast>();
    protected static AtomicInteger mAtomicInteger = new AtomicInteger(0);
    private WindowManager mWindowManager;
    private long mDurationMillis;
    private View mView;
    private WindowManager.LayoutParams mParams;
    private Context mContext;
    private final Runnable mShow = new Runnable(){

        @Override
        public void run() {
            MIUIToast.this.handleShow();
        }
    };
    private final Runnable mHide = new Runnable(){

        @Override
        public void run() {
            MIUIToast.this.handleHide();
        }
    };
    private static final Runnable mActivite = new Runnable(){

        @Override
        public void run() {
            MIUIToast.activeQueue();
        }
    };

    public static IToast makeText(Context context, String text, long duration) {
        return new MIUIToast(context).setText(text).setDuration(duration).setGravity(80, 0, DisplayUtil.dip2px(context, 64.0f));
    }

    public MIUIToast(Context context) {
        this.mContext = context;
        this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        this.mParams = new WindowManager.LayoutParams();
        this.mParams.height = -2;
        this.mParams.width = -2;
        this.mParams.format = -3;
        this.mParams.windowAnimations = 16973828;
        this.mParams.type = 2005;
        this.mParams.setTitle((CharSequence)"Toast");
        this.mParams.flags = 152;
        this.mParams.gravity = 81;
    }

    @Override
    @TargetApi(value=17)
    public IToast setGravity(int gravity, int xOffset, int yOffset) {
        int finalGravity;
        if (Build.VERSION.SDK_INT >= 14) {
            Configuration config = this.mView.getContext().getResources().getConfiguration();
            finalGravity = Gravity.getAbsoluteGravity((int)gravity, (int)config.getLayoutDirection());
        } else {
            finalGravity = gravity;
        }
        this.mParams.gravity = finalGravity;
        if ((finalGravity & 7) == 7) {
            this.mParams.horizontalWeight = 1.0f;
        }
        if ((finalGravity & 0x70) == 112) {
            this.mParams.verticalWeight = 1.0f;
        }
        this.mParams.y = yOffset;
        this.mParams.x = xOffset;
        return this;
    }

    @Override
    public IToast setDuration(long durationMillis) {
        if (durationMillis < 0L) {
            this.mDurationMillis = 0L;
        }
        this.mDurationMillis = durationMillis == 0L ? 2000L : (durationMillis == 1L ? 3500L : durationMillis);
        return this;
    }

    @Override
    public IToast setView(View view) {
        this.mView = view;
        return this;
    }

    @Override
    public IToast setMargin(float horizontalMargin, float verticalMargin) {
        this.mParams.horizontalMargin = horizontalMargin;
        this.mParams.verticalMargin = verticalMargin;
        return this;
    }

    @Override
    public IToast setText(String text) {
        View view = Toast.makeText((Context)this.mContext, (CharSequence)text, (int)0).getView();
        if (view != null) {
            TextView tv = (TextView)view.findViewById(16908299);
            tv.setText((CharSequence)text);
            this.setView(view);
        }
        return this;
    }

    @Override
    public void show() {
        mQueue.offer(this);
        if (0 == mAtomicInteger.get()) {
            mAtomicInteger.incrementAndGet();
            mHandler.post(mActivite);
        }
    }

    @Override
    public void cancel() {
        if (0 == mAtomicInteger.get() && mQueue.isEmpty()) {
            return;
        }
        if (this.equals(mQueue.peek())) {
            mHandler.removeCallbacks(mActivite);
            mHandler.post(this.mHide);
            mHandler.post(mActivite);
        }
    }

    private void handleShow() {
        if (this.mView != null) {
            if (this.mView.getParent() != null) {
                this.mWindowManager.removeView(this.mView);
            }
            this.mWindowManager.addView(this.mView, (ViewGroup.LayoutParams)this.mParams);
        }
    }

    private void handleHide() {
        if (this.mView != null) {
            if (this.mView.getParent() != null) {
                this.mWindowManager.removeView(this.mView);
                mQueue.poll();
            }
            this.mView = null;
        }
    }

    private static void activeQueue() {
        MIUIToast miuiToast = (MIUIToast)mQueue.peek();
        if (miuiToast == null) {
            mAtomicInteger.decrementAndGet();
        } else {
            mHandler.post(miuiToast.mShow);
            mHandler.postDelayed(miuiToast.mHide, miuiToast.mDurationMillis);
            mHandler.postDelayed(mActivite, miuiToast.mDurationMillis);
        }
    }
}

